/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/open_api3_request_validation_handler */
var utils = require('vertx-js/util/utils');
var RoutingContext = require('vertx-web-js/routing_context');
var HTTPOperationRequestValidationHandler = require('vertx-web-api-contract-js/http_operation_request_validation_handler');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JOpenAPI3RequestValidationHandler = Java.type('io.vertx.ext.web.api.contract.openapi3.OpenAPI3RequestValidationHandler');

/**

 @class
*/
var OpenAPI3RequestValidationHandler = function(j_val) {

  var j_openAPI3RequestValidationHandler = j_val;
  var that = this;
  HTTPOperationRequestValidationHandler.call(this, j_val);

  var __super_handle = this.handle;
  var __super_parseOperationSpec = this.parseOperationSpec;
  /**
   Something has happened, so handle it.

   @public
   @param event {RoutingContext} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_openAPI3RequestValidationHandler["handle(io.vertx.ext.web.RoutingContext)"](event._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Function that parse the operation specification and generate validation rules

   @public

   */
  this.parseOperationSpec =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_openAPI3RequestValidationHandler["parseOperationSpec()"]();
    } else if (typeof __super_parseOperationSpec != 'undefined') {
      return __super_parseOperationSpec.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_openAPI3RequestValidationHandler;
};

OpenAPI3RequestValidationHandler._jclass = utils.getJavaClass("io.vertx.ext.web.api.contract.openapi3.OpenAPI3RequestValidationHandler");
OpenAPI3RequestValidationHandler._jtype = {accept: function(obj) {
    return OpenAPI3RequestValidationHandler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(OpenAPI3RequestValidationHandler.prototype, {});
    OpenAPI3RequestValidationHandler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
OpenAPI3RequestValidationHandler._create = function(jdel) {var obj = Object.create(OpenAPI3RequestValidationHandler.prototype, {});
  OpenAPI3RequestValidationHandler.apply(obj, arguments);
  return obj;
}
module.exports = OpenAPI3RequestValidationHandler;
var Promise = require('vertx-js/promise');
