/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-api-contract-js/router_factory */
var utils = require('vertx-js/util/utils');
var Router = require('vertx-web-js/router');
var RoutingContext = require('vertx-web-js/routing_context');
var BodyHandler = require('vertx-web-js/body_handler');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JRouterFactory = Java.type('io.vertx.ext.web.api.contract.RouterFactory');
var RouterFactoryOptions = Java.type('io.vertx.ext.web.api.contract.RouterFactoryOptions');

/**
 Main interface for Design Driven Router factory
 @class
*/
var RouterFactory = function(j_val, j_arg_0) {

  var j_routerFactory = j_val;
  var that = this;
  var j_Specification = typeof j_arg_0 !== 'undefined' ? j_arg_0 : utils.unknown_jtype;
  var __super_addSecurityHandler = this.addSecurityHandler;
  var __super_setOptions = this.setOptions;
  var __super_getOptions = this.getOptions;
  var __super_getRouter = this.getRouter;
  var __super_getValidationFailureHandler = this.getValidationFailureHandler;
  var __super_setValidationFailureHandler = this.setValidationFailureHandler;
  var __super_setNotImplementedFailureHandler = this.setNotImplementedFailureHandler;
  var __super_setBodyHandler = this.setBodyHandler;
  var __super_addGlobalHandler = this.addGlobalHandler;
  var __super_setExtraOperationContextPayloadMapper = this.setExtraOperationContextPayloadMapper;
  /**
   Mount to paths that have to follow a security schema a security handler

   @public
   @param securitySchemaName {string} 
   @param handler {function} 
   @return {RouterFactory} 
   */
  this.addSecurityHandler =  function(securitySchemaName, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_routerFactory["addSecurityHandler(java.lang.String,io.vertx.core.Handler)"](securitySchemaName, function(jVal) {
        handler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addSecurityHandler != 'undefined') {
      return __super_addSecurityHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set options of router factory. For more info <a href="../../dataobjects.html#RouterFactoryOptions">RouterFactoryOptions</a>

   @public
   @param options {Object} 
   @return {RouterFactory} 
   */
  this.setOptions =  function(options) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_routerFactory["setOptions(io.vertx.ext.web.api.contract.RouterFactoryOptions)"](options  != null ? new RouterFactoryOptions(new JsonObject(Java.asJSONCompatible(options))) : null) ;
      return that;
    } else if (typeof __super_setOptions != 'undefined') {
      return __super_setOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get options of router factory. For more info <a href="../../dataobjects.html#RouterFactoryOptions">RouterFactoryOptions</a>

   @public

   @return {Object} 
   */
  this.getOptions =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnDataObjectAnnotated(j_routerFactory["getOptions()"]()) ;
    } else if (typeof __super_getOptions != 'undefined') {
      return __super_getOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Construct a new router based on spec. It will fail if you are trying to mount a spec with security schemes
   without assigned handlers<br/>
   <b>Note:</b> Router is constructed in this function, so it will be respected the path definition ordering.

   @public

   @return {Router} 
   */
  this.getRouter =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(Router, j_routerFactory["getRouter()"]()) ;
    } else if (typeof __super_getRouter != 'undefined') {
      return __super_getRouter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {function}
   */
  this.getValidationFailureHandler =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnHandler(j_routerFactory["getValidationFailureHandler()"](), function(result) { return result._jdel; }) ;
    } else if (typeof __super_getValidationFailureHandler != 'undefined') {
      return __super_getValidationFailureHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set default validation failure handler. You can enable/disable this feature from
   <a href="../../dataobjects.html#RouterFactoryOptions">RouterFactoryOptions</a>

   @public
   @param validationFailureHandler {function} 
   @return {RouterFactory} this object
   */
  this.setValidationFailureHandler =  function(validationFailureHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_routerFactory["setValidationFailureHandler(io.vertx.core.Handler)"](function(jVal) {
        validationFailureHandler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_setValidationFailureHandler != 'undefined') {
      return __super_setValidationFailureHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set not implemented failure handler. It's called when you don't define an handler for a
   specific operation. You can enable/disable this feature from
   <a href="../../dataobjects.html#RouterFactoryOptions">RouterFactoryOptions</a>

   @public
   @param notImplementedFailureHandler {function} 
   @return {RouterFactory} this object
   */
  this.setNotImplementedFailureHandler =  function(notImplementedFailureHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_routerFactory["setNotImplementedFailureHandler(io.vertx.core.Handler)"](function(jVal) {
        notImplementedFailureHandler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_setNotImplementedFailureHandler != 'undefined') {
      return __super_setNotImplementedFailureHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Supply your own BodyHandler if you would like to control body limit, uploads directory and deletion of uploaded files

   @public
   @param bodyHandler {BodyHandler} 
   @return {RouterFactory} self
   */
  this.setBodyHandler =  function(bodyHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_routerFactory["setBodyHandler(io.vertx.ext.web.handler.BodyHandler)"](bodyHandler._jdel) ;
      return that;
    } else if (typeof __super_setBodyHandler != 'undefined') {
      return __super_setBodyHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add global handler to be applied prior to {@link Router} being generated. <br/>
   Please note that you should not add a body handler inside that list. If you want to modify the body handler, please use {@link RouterFactory#setBodyHandler}

   @public
   @param globalHandler {function} 
   @return {RouterFactory} this object
   */
  this.addGlobalHandler =  function(globalHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_routerFactory["addGlobalHandler(io.vertx.core.Handler)"](function(jVal) {
        globalHandler(utils.convReturnVertxGen(RoutingContext, jVal));
      }) ;
      return that;
    } else if (typeof __super_addGlobalHandler != 'undefined') {
      return __super_addGlobalHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   When set, this function is called while creating the payload of <a href="../../dataobjects.html#OperationRequest">OperationRequest</a>

   @public
   @param extraOperationContextPayloadMapper {function} 
   @return {RouterFactory} 
   */
  this.setExtraOperationContextPayloadMapper =  function(extraOperationContextPayloadMapper) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_routerFactory["setExtraOperationContextPayloadMapper(java.util.function.Function)"](function(jVal) {
        var jRet = extraOperationContextPayloadMapper(utils.convReturnVertxGen(RoutingContext, jVal));
        return utils.convParamJsonObject(jRet);
      }) ;
      return that;
    } else if (typeof __super_setExtraOperationContextPayloadMapper != 'undefined') {
      return __super_setExtraOperationContextPayloadMapper.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_routerFactory;
};

RouterFactory._jclass = utils.getJavaClass("io.vertx.ext.web.api.contract.RouterFactory");
RouterFactory._jtype = {accept: function(obj) {
    return RouterFactory._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(RouterFactory.prototype, {});
    RouterFactory.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RouterFactory._create = function(jdel) {var obj = Object.create(RouterFactory.prototype, {});
  RouterFactory.apply(obj, arguments);
  return obj;
}
module.exports = RouterFactory;
var Promise = require('vertx-js/promise');
