/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-client-js/response_predicate */
var utils = require('vertx-js/util/utils');
var HttpResponse = require('vertx-web-client-js/http_response');
var ErrorConverter = require('vertx-web-client-js/error_converter');
var ResponsePredicateResult = require('vertx-web-client-js/response_predicate_result');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JResponsePredicate = Java.type('io.vertx.ext.web.client.predicate.ResponsePredicate');

/**

 @class
*/
var ResponsePredicate = function(j_val) {

  var j_responsePredicate = j_val;
  var that = this;

  var __super_status = this.status;
  var __super_status = this.status;
  var __super_contentType = this.contentType;
  var __super_contentType = this.contentType;
  var __super_create = this.create;
  var __super_create = this.create;
  var __super_errorConverter = this.errorConverter;
  /**

   @public

   @return {ErrorConverter} the error converter currently used
   */
  this.errorConverter =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(ErrorConverter, j_responsePredicate["errorConverter()"]()) ;
    } else if (typeof __super_errorConverter != 'undefined') {
      return __super_errorConverter.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_responsePredicate;
};

ResponsePredicate._jclass = utils.getJavaClass("io.vertx.ext.web.client.predicate.ResponsePredicate");
ResponsePredicate._jtype = {accept: function(obj) {
    return ResponsePredicate._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ResponsePredicate.prototype, {});
    ResponsePredicate.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ResponsePredicate._create = function(jdel) {var obj = Object.create(ResponsePredicate.prototype, {});
  ResponsePredicate.apply(obj, arguments);
  return obj;
}
/**
 Creates a predicate asserting that the status response code is in the <code>[min,max[</code> range.

 @memberof module:vertx-web-client-js/response_predicate
 @param min {number} the lower (inclusive) accepted status code 
 @param max {number} the highest (exclusive) accepted status code 
 @return {ResponsePredicate}
 */
ResponsePredicate.status =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] ==='number') {
    return utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate["status(int)"](__args[0])) ;
  } else if (__args.length === 2 && typeof __args[0] ==='number' && typeof __args[1] ==='number') {
    return utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate["status(int,int)"](__args[0], __args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Creates a predicate validating the response has a <code>content-type</code> header matching one of the <code>mimeTypes</code>.

 @memberof module:vertx-web-client-js/response_predicate
 @param mimeTypes {Array.<string>} the list of mime types 
 @return {ResponsePredicate}
 */
ResponsePredicate.contentType =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'string') {
    return utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate["contentType(java.lang.String)"](__args[0])) ;
  } else if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
    return utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate["contentType(java.util.List)"](utils.convParamListBasicOther(__args[0]))) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Creates a new {@link ResponsePredicate}, using a custom <code>errorConverter</code>.

 @memberof module:vertx-web-client-js/response_predicate
 @param test {function} the function to invoke when the response is received 
 @param errorConverter {ErrorConverter} converts the result of the <code>test</code> function to a Throwable 
 @return {ResponsePredicate}
 */
ResponsePredicate.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'function') {
    return utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate["create(java.util.function.Function)"](function(jVal) {
      var jRet = __args[0](utils.convReturnVertxGen(HttpResponse, jVal, undefined));
      return jRet._jdel;
    })) ;
  } else if (__args.length === 2 && typeof __args[0] === 'function' && typeof __args[1] === 'object' && __args[1]._jdel) {
    return utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate["create(java.util.function.Function,io.vertx.ext.web.client.predicate.ErrorConverter)"](function(jVal) {
      var jRet = __args[0](utils.convReturnVertxGen(HttpResponse, jVal, undefined));
      return jRet._jdel;
    }, __args[1]._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

ResponsePredicate.SC_INFORMATIONAL_RESPONSE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_INFORMATIONAL_RESPONSE);
ResponsePredicate.SC_CONTINUE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_CONTINUE);
ResponsePredicate.SC_SWITCHING_PROTOCOLS = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_SWITCHING_PROTOCOLS);
ResponsePredicate.SC_PROCESSING = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_PROCESSING);
ResponsePredicate.SC_EARLY_HINTS = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_EARLY_HINTS);
ResponsePredicate.SC_SUCCESS = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_SUCCESS);
ResponsePredicate.SC_OK = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_OK);
ResponsePredicate.SC_CREATED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_CREATED);
ResponsePredicate.SC_ACCEPTED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_ACCEPTED);
ResponsePredicate.SC_NON_AUTHORITATIVE_INFORMATION = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_NON_AUTHORITATIVE_INFORMATION);
ResponsePredicate.SC_NO_CONTENT = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_NO_CONTENT);
ResponsePredicate.SC_RESET_CONTENT = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_RESET_CONTENT);
ResponsePredicate.SC_PARTIAL_CONTENT = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_PARTIAL_CONTENT);
ResponsePredicate.SC_MULTI_STATUS = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_MULTI_STATUS);
ResponsePredicate.SC_REDIRECTION = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_REDIRECTION);
ResponsePredicate.SC_MULTIPLE_CHOICES = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_MULTIPLE_CHOICES);
ResponsePredicate.SC_MOVED_PERMANENTLY = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_MOVED_PERMANENTLY);
ResponsePredicate.SC_FOUND = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_FOUND);
ResponsePredicate.SC_SEE_OTHER = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_SEE_OTHER);
ResponsePredicate.SC_NOT_MODIFIED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_NOT_MODIFIED);
ResponsePredicate.SC_USE_PROXY = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_USE_PROXY);
ResponsePredicate.SC_TEMPORARY_REDIRECT = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_TEMPORARY_REDIRECT);
ResponsePredicate.SC_PERMANENT_REDIRECT = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_PERMANENT_REDIRECT);
ResponsePredicate.SC_CLIENT_ERRORS = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_CLIENT_ERRORS);
ResponsePredicate.SC_BAD_REQUEST = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_BAD_REQUEST);
ResponsePredicate.SC_UNAUTHORIZED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_UNAUTHORIZED);
ResponsePredicate.SC_PAYMENT_REQUIRED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_PAYMENT_REQUIRED);
ResponsePredicate.SC_FORBIDDEN = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_FORBIDDEN);
ResponsePredicate.SC_NOT_FOUND = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_NOT_FOUND);
ResponsePredicate.SC_METHOD_NOT_ALLOWED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_METHOD_NOT_ALLOWED);
ResponsePredicate.SC_NOT_ACCEPTABLE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_NOT_ACCEPTABLE);
ResponsePredicate.SC_PROXY_AUTHENTICATION_REQUIRED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_PROXY_AUTHENTICATION_REQUIRED);
ResponsePredicate.SC_REQUEST_TIMEOUT = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_REQUEST_TIMEOUT);
ResponsePredicate.SC_CONFLICT = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_CONFLICT);
ResponsePredicate.SC_GONE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_GONE);
ResponsePredicate.SC_LENGTH_REQUIRED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_LENGTH_REQUIRED);
ResponsePredicate.SC_PRECONDITION_FAILED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_PRECONDITION_FAILED);
ResponsePredicate.SC_REQUEST_ENTITY_TOO_LARGE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_REQUEST_ENTITY_TOO_LARGE);
ResponsePredicate.SC_REQUEST_URI_TOO_LONG = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_REQUEST_URI_TOO_LONG);
ResponsePredicate.SC_UNSUPPORTED_MEDIA_TYPE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_UNSUPPORTED_MEDIA_TYPE);
ResponsePredicate.SC_REQUESTED_RANGE_NOT_SATISFIABLE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_REQUESTED_RANGE_NOT_SATISFIABLE);
ResponsePredicate.SC_EXPECTATION_FAILED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_EXPECTATION_FAILED);
ResponsePredicate.SC_MISDIRECTED_REQUEST = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_MISDIRECTED_REQUEST);
ResponsePredicate.SC_UNPROCESSABLE_ENTITY = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_UNPROCESSABLE_ENTITY);
ResponsePredicate.SC_LOCKED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_LOCKED);
ResponsePredicate.SC_FAILED_DEPENDENCY = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_FAILED_DEPENDENCY);
ResponsePredicate.SC_UNORDERED_COLLECTION = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_UNORDERED_COLLECTION);
ResponsePredicate.SC_UPGRADE_REQUIRED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_UPGRADE_REQUIRED);
ResponsePredicate.SC_PRECONDITION_REQUIRED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_PRECONDITION_REQUIRED);
ResponsePredicate.SC_TOO_MANY_REQUESTS = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_TOO_MANY_REQUESTS);
ResponsePredicate.SC_REQUEST_HEADER_FIELDS_TOO_LARGE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_REQUEST_HEADER_FIELDS_TOO_LARGE);
ResponsePredicate.SC_SERVER_ERRORS = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_SERVER_ERRORS);
ResponsePredicate.SC_INTERNAL_SERVER_ERROR = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_INTERNAL_SERVER_ERROR);
ResponsePredicate.SC_NOT_IMPLEMENTED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_NOT_IMPLEMENTED);
ResponsePredicate.SC_BAD_GATEWAY = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_BAD_GATEWAY);
ResponsePredicate.SC_SERVICE_UNAVAILABLE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_SERVICE_UNAVAILABLE);
ResponsePredicate.SC_GATEWAY_TIMEOUT = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_GATEWAY_TIMEOUT);
ResponsePredicate.SC_HTTP_VERSION_NOT_SUPPORTED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_HTTP_VERSION_NOT_SUPPORTED);
ResponsePredicate.SC_VARIANT_ALSO_NEGOTIATES = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_VARIANT_ALSO_NEGOTIATES);
ResponsePredicate.SC_INSUFFICIENT_STORAGE = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_INSUFFICIENT_STORAGE);
ResponsePredicate.SC_NOT_EXTENDED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_NOT_EXTENDED);
ResponsePredicate.SC_NETWORK_AUTHENTICATION_REQUIRED = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.SC_NETWORK_AUTHENTICATION_REQUIRED);
ResponsePredicate.JSON = utils.convReturnVertxGen(ResponsePredicate, JResponsePredicate.JSON);
module.exports = ResponsePredicate;
var Promise = require('vertx-js/promise');
