/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-common-js/multipart_form */
var utils = require('vertx-js/util/utils');
var FormDataPart = require('vertx-web-common-js/form_data_part');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JMultipartForm = Java.type('io.vertx.ext.web.multipart.MultipartForm');

/**
 A multipart form.

 @class
*/
var MultipartForm = function(j_val) {

  var j_multipartForm = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_attribute = this.attribute;
  var __super_textFileUpload = this.textFileUpload;
  var __super_binaryFileUpload = this.binaryFileUpload;
  /**
   Add an attribute form data part.

   @public
   @param name {string} the name of the attribute 
   @param value {string} the value of the attribute 
   @return {MultipartForm} a reference to this, so the API can be used fluently
   */
  this.attribute =  function(name, value) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'string') {
      j_multipartForm["attribute(java.lang.String,java.lang.String)"](name, value) ;
      return that;
    } else if (typeof __super_attribute != 'undefined') {
      return __super_attribute.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a text file upload form data part.

   @public
   @param name {string} name of the parameter 
   @param filename {string} filename of the file 
   @param pathname {string} the pathname of the file 
   @param mediaType {string} the MIME type of the file 
   @return {MultipartForm} a reference to this, so the API can be used fluently
   */
  this.textFileUpload =  function(name, filename, pathname, mediaType) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'string') {
      j_multipartForm["textFileUpload(java.lang.String,java.lang.String,java.lang.String,java.lang.String)"](name, filename, pathname, mediaType) ;
      return that;
    } else if (typeof __super_textFileUpload != 'undefined') {
      return __super_textFileUpload.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a binary file upload form data part.

   @public
   @param name {string} name of the parameter 
   @param filename {string} filename of the file 
   @param pathname {string} the pathname of the file 
   @param mediaType {string} the MIME type of the file 
   @return {MultipartForm} a reference to this, so the API can be used fluently
   */
  this.binaryFileUpload =  function(name, filename, pathname, mediaType) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'string') {
      j_multipartForm["binaryFileUpload(java.lang.String,java.lang.String,java.lang.String,java.lang.String)"](name, filename, pathname, mediaType) ;
      return that;
    } else if (typeof __super_binaryFileUpload != 'undefined') {
      return __super_binaryFileUpload.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_multipartForm;
};

MultipartForm._jclass = utils.getJavaClass("io.vertx.ext.web.multipart.MultipartForm");
MultipartForm._jtype = {accept: function(obj) {
    return MultipartForm._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(MultipartForm.prototype, {});
    MultipartForm.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MultipartForm._create = function(jdel) {var obj = Object.create(MultipartForm.prototype, {});
  MultipartForm.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-web-common-js/multipart_form

 @return {MultipartForm} a multipart form instance
 */
MultipartForm.create =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return utils.convReturnVertxGen(MultipartForm, JMultipartForm["create()"]()) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = MultipartForm;
var Promise = require('vertx-js/promise');
