/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-graphql-js/apollo_ws_handler */
var utils = require('vertx-js/util/utils');
var ServerWebSocket = require('vertx-js/server_web_socket');
var ApolloWSMessage = require('vertx-web-graphql-js/apollo_ws_message');
var RoutingContext = require('vertx-web-js/routing_context');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JApolloWSHandler = Java.type('io.vertx.ext.web.handler.graphql.ApolloWSHandler');
var ApolloWSOptions = Java.type('io.vertx.ext.web.handler.graphql.ApolloWSOptions');

/**

 @class
*/
var ApolloWSHandler = function(j_val) {

  var j_apolloWSHandler = j_val;
  var that = this;

  var __super_handle = this.handle;
  var __super_connectionHandler = this.connectionHandler;
  var __super_messageHandler = this.messageHandler;
  var __super_endHandler = this.endHandler;
  var __super_queryContext = this.queryContext;
  /**
   Something has happened, so handle it.

   @public
   @param event {RoutingContext} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_apolloWSHandler["handle(io.vertx.ext.web.RoutingContext)"](event._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Customize the connection .
   This handler will be called at the beginning of each websocket connection.

   @public
   @param connectionHandler {function} 
   @return {ApolloWSHandler} a reference to this, so the API can be used fluently
   */
  this.connectionHandler =  function(connectionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_apolloWSHandler["connectionHandler(io.vertx.core.Handler)"](function(jVal) {
        connectionHandler(utils.convReturnVertxGen(ServerWebSocket, jVal));
      }) ;
      return that;
    } else if (typeof __super_connectionHandler != 'undefined') {
      return __super_connectionHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Customize the message .
   This handler will be called for each {@link ApolloWSMessage} received.

   @public
   @param messageHandler {function} 
   @return {ApolloWSHandler} a reference to this, so the API can be used fluently
   */
  this.messageHandler =  function(messageHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_apolloWSHandler["messageHandler(io.vertx.core.Handler)"](function(jVal) {
        messageHandler(utils.convReturnVertxGen(ApolloWSMessage, jVal));
      }) ;
      return that;
    } else if (typeof __super_messageHandler != 'undefined') {
      return __super_messageHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Customize the end .
   This handler will be called at the end of each websocket connection.

   @public
   @param endHandler {function} 
   @return {ApolloWSHandler} a reference to this, so the API can be used fluently
   */
  this.endHandler =  function(endHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_apolloWSHandler["endHandler(io.vertx.core.Handler)"](function(jVal) {
        endHandler(utils.convReturnVertxGen(ServerWebSocket, jVal));
      }) ;
      return that;
    } else if (typeof __super_endHandler != 'undefined') {
      return __super_endHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Customize the query context object.
   The provided <code>factory</code> method will be invoked for each incoming GraphQL request.

   @public
   @param factory {function} 
   @return {ApolloWSHandler} a reference to this, so the API can be used fluently
   */
  this.queryContext =  function(factory) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_apolloWSHandler["queryContext(java.util.function.Function)"](function(jVal) {
        var jRet = factory(utils.convReturnVertxGen(ApolloWSMessage, jVal));
        return utils.convParamTypeUnknown(jRet);
      }) ;
      return that;
    } else if (typeof __super_queryContext != 'undefined') {
      return __super_queryContext.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_apolloWSHandler;
};

ApolloWSHandler._jclass = utils.getJavaClass("io.vertx.ext.web.handler.graphql.ApolloWSHandler");
ApolloWSHandler._jtype = {accept: function(obj) {
    return ApolloWSHandler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ApolloWSHandler.prototype, {});
    ApolloWSHandler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ApolloWSHandler._create = function(jdel) {var obj = Object.create(ApolloWSHandler.prototype, {});
  ApolloWSHandler.apply(obj, arguments);
  return obj;
}
module.exports = ApolloWSHandler;
var Promise = require('vertx-js/promise');
