/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-graphql-js/apollo_ws_message */
var utils = require('vertx-js/util/utils');
var ServerWebSocket = require('vertx-js/server_web_socket');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JApolloWSMessage = Java.type('io.vertx.ext.web.handler.graphql.ApolloWSMessage');

/**

 @class
*/
var ApolloWSMessage = function(j_val) {

  var j_apolloWSMessage = j_val;
  var that = this;

  var __super_serverWebSocket = this.serverWebSocket;
  var __super_type = this.type;
  var __super_content = this.content;
  /**

   @public

   @return {ServerWebSocket} the websocket that received the message
   */
  this.serverWebSocket =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnVertxGen(ServerWebSocket, j_apolloWSMessage["serverWebSocket()"]()) ;
    } else if (typeof __super_serverWebSocket != 'undefined') {
      return __super_serverWebSocket.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object} the message type
   */
  this.type =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnEnum(j_apolloWSMessage["type()"]()) ;
    } else if (typeof __super_type != 'undefined') {
      return __super_type.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object} the message content
   */
  this.content =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnJson(j_apolloWSMessage["content()"]()) ;
    } else if (typeof __super_content != 'undefined') {
      return __super_content.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_apolloWSMessage;
};

ApolloWSMessage._jclass = utils.getJavaClass("io.vertx.ext.web.handler.graphql.ApolloWSMessage");
ApolloWSMessage._jtype = {accept: function(obj) {
    return ApolloWSMessage._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ApolloWSMessage.prototype, {});
    ApolloWSMessage.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ApolloWSMessage._create = function(jdel) {var obj = Object.create(ApolloWSMessage.prototype, {});
  ApolloWSMessage.apply(obj, arguments);
  return obj;
}
module.exports = ApolloWSMessage;
var Promise = require('vertx-js/promise');
