/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-js/authorization_handler */
var utils = require('vertx-js/util/utils');
var Authorization = require('vertx-auth-common-js/authorization');
var RoutingContext = require('vertx-web-js/routing_context');
var AuthorizationProvider = require('vertx-auth-common-js/authorization_provider');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JAuthorizationHandler = Java.type('io.vertx.ext.web.handler.AuthorizationHandler');

/**
 Base interface for authorization handlers that provide authorization support.
 <p>
 @class
*/
var AuthorizationHandler = function(j_val) {

  var j_authorizationHandler = j_val;
  var that = this;

  var __super_handle = this.handle;
  var __super_create = this.create;
  var __super_addAuthorizationProvider = this.addAuthorizationProvider;
  /**
   Something has happened, so handle it.

   @public
   @param event {RoutingContext} the event to handle 
   */
  this.handle =  function(event) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_authorizationHandler["handle(io.vertx.ext.web.RoutingContext)"](event._jdel);
    } else if (typeof __super_handle != 'undefined') {
      return __super_handle.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Adds a provider that shall be used to retrieve the required authorizations for the user to attest.
   Multiple calls are allowed to retrieve authorizations from many sources.

   @public
   @param authorizationProvider {AuthorizationProvider} a provider. 
   @return {AuthorizationHandler} fluent self.
   */
  this.addAuthorizationProvider =  function(authorizationProvider) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_authorizationHandler["addAuthorizationProvider(io.vertx.ext.auth.authorization.AuthorizationProvider)"](authorizationProvider._jdel) ;
      return that;
    } else if (typeof __super_addAuthorizationProvider != 'undefined') {
      return __super_addAuthorizationProvider.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_authorizationHandler;
};

AuthorizationHandler._jclass = utils.getJavaClass("io.vertx.ext.web.handler.AuthorizationHandler");
AuthorizationHandler._jtype = {accept: function(obj) {
    return AuthorizationHandler._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(AuthorizationHandler.prototype, {});
    AuthorizationHandler.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
AuthorizationHandler._create = function(jdel) {var obj = Object.create(AuthorizationHandler.prototype, {});
  AuthorizationHandler.apply(obj, arguments);
  return obj;
}
/**
 create the the handler that will check the specified authorization
 Note that to check several authorizations, you can specify a sub-interface such as {@link AndAuthorization} or {@link OrAuthorization}

 @memberof module:vertx-web-js/authorization_handler
 @param authorization {Authorization} the authorization to attest. 
 @return {AuthorizationHandler} fluent self.
 */
AuthorizationHandler.create =  function(authorization) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(AuthorizationHandler, JAuthorizationHandler["create(io.vertx.ext.auth.authorization.Authorization)"](authorization._jdel)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = AuthorizationHandler;
var Promise = require('vertx-js/promise');
