/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-templ-pebble-js/pebble_template_engine */
var utils = require('vertx-js/util/utils');
var TemplateEngine = require('vertx-web-common-js/template_engine');
var Vertx = require('vertx-js/vertx');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JsonArray = io.vertx.core.json.JsonArray;
var JPebbleTemplateEngine = Java.type('io.vertx.ext.web.templ.pebble.PebbleTemplateEngine');

/**
 A template engine that uses the Pebble library.

 @class
*/
var PebbleTemplateEngine = function(j_val) {

  var j_pebbleTemplateEngine = j_val;
  var that = this;
  TemplateEngine.call(this, j_val);

  var __super_create = this.create;
  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_pebbleTemplateEngine;
};

PebbleTemplateEngine._jclass = utils.getJavaClass("io.vertx.ext.web.templ.pebble.PebbleTemplateEngine");
PebbleTemplateEngine._jtype = {accept: function(obj) {
    return PebbleTemplateEngine._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(PebbleTemplateEngine.prototype, {});
    PebbleTemplateEngine.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
PebbleTemplateEngine._create = function(jdel) {var obj = Object.create(PebbleTemplateEngine.prototype, {});
  PebbleTemplateEngine.apply(obj, arguments);
  return obj;
}
/**
 Create a template engine using defaults

 @memberof module:vertx-web-templ-pebble-js/pebble_template_engine
 @param vertx {Vertx} 
 @param extension {string} 
 @return {PebbleTemplateEngine} the engine
 */
PebbleTemplateEngine.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(PebbleTemplateEngine, JPebbleTemplateEngine["create(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string') {
    return utils.convReturnVertxGen(PebbleTemplateEngine, JPebbleTemplateEngine["create(io.vertx.core.Vertx,java.lang.String)"](__args[0]._jdel, __args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

PebbleTemplateEngine.DEFAULT_TEMPLATE_EXTENSION = JPebbleTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
module.exports = PebbleTemplateEngine;
var Promise = require('vertx-js/promise');
