/*
 * Decompiled with CFR 0.152.
 */
package io.vertx;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Test;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\b\u0010\n\u001a\u00020\bH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007J\b\u0010\f\u001a\u00020\bH\u0007J\b\u0010\r\u001a\u00020\bH\u0007J\b\u0010\u000e\u001a\u00020\bH\u0007J\b\u0010\u000f\u001a\u00020\bH\u0007J\b\u0010\u0010\u001a\u00020\bH\u0007J\b\u0010\u0011\u001a\u00020\bH\u0007J\b\u0010\u0012\u001a\u00020\bH\u0007J\b\u0010\u0013\u001a\u00020\bH\u0007J\b\u0010\u0014\u001a\u00020\bH\u0007J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lio/vertx/KotlinVerticleFactoryTest;", "", "()V", "vertx", "Lio/vertx/core/Vertx;", "getVertx", "()Lio/vertx/core/Vertx;", "tearDown", "", "testIncompleteTypes", "testIndirectInheritance", "testMultiple", "testPackageSpecified", "testPrivateTypes", "testRelativePath", "testScript", "testScriptAsyncStart", "testScriptWithAsyncStop", "testScriptWithStop", "testSealedVerticles", "testSingle", "deployVerticleBlocking", "", "name", "vertx-lang-kotlin-compiler"})
public final class KotlinVerticleFactoryTest {
    @NotNull
    private final Vertx vertx;

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    @After
    public final void tearDown() {
        this.vertx.close();
    }

    @Test
    public final void testSingle() {
        this.deployVerticleBlocking(this.vertx, "singleVerticle.kt");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void testMultiple() {
        this.deployVerticleBlocking(this.vertx, "multipleVerticles.kt");
        int n = 1;
        int n2 = 3;
        while (n <= n2) {
            void i;
            AssertionsKt.assertEquals$default((Object)String.valueOf((int)i), (Object)this.vertx.sharedData().getLocalMap("M").get((Object)("" + 'M' + (int)i)), null, (int)4, null);
            ++i;
        }
    }

    @Test
    public final void testScript() {
        CompletableFuture fut = new CompletableFuture();
        this.vertx.eventBus().consumer("test-address", (Handler)new Handler<Message<String>>(fut){
            final /* synthetic */ CompletableFuture $fut;

            public final void handle(Message<String> it) {
                this.$fut.complete(it.body());
            }
            {
                this.$fut = completableFuture;
            }
        });
        String id = this.deployVerticleBlocking(this.vertx, "scriptVerticle.kts");
        AssertionsKt.assertEquals$default((Object)id, fut.get(10L, TimeUnit.SECONDS), null, (int)4, null);
    }

    @Test
    public final void testScriptAsyncStart() {
        CompletableFuture fut = new CompletableFuture();
        this.vertx.eventBus().consumer("test-address", (Handler)new Handler<Message<String>>(fut){
            final /* synthetic */ CompletableFuture $fut;

            public final void handle(Message<String> it) {
                this.$fut.complete(it.body());
            }
            {
                this.$fut = completableFuture;
            }
        });
        String id = this.deployVerticleBlocking(this.vertx, "scriptVerticleWithAsyncStart.kts");
        AssertionsKt.assertEquals$default((Object)id, fut.get(10L, TimeUnit.SECONDS), null, (int)4, null);
    }

    @Test
    public final void testScriptWithStop() {
        CompletableFuture fut = new CompletableFuture();
        this.vertx.eventBus().consumer("test-address", (Handler)new Handler<Message<String>>(fut){
            final /* synthetic */ CompletableFuture $fut;

            public final void handle(Message<String> it) {
                this.$fut.complete(it.body());
            }
            {
                this.$fut = completableFuture;
            }
        });
        String id = this.deployVerticleBlocking(this.vertx, "scriptVerticleWithStop.kts");
        this.vertx.undeploy(id);
        AssertionsKt.assertEquals$default((Object)id, fut.get(10L, TimeUnit.SECONDS), null, (int)4, null);
    }

    @Test
    public final void testScriptWithAsyncStop() {
        CompletableFuture fut = new CompletableFuture();
        this.vertx.eventBus().consumer("test-address", (Handler)new Handler<Message<String>>(fut){
            final /* synthetic */ CompletableFuture $fut;

            public final void handle(Message<String> it) {
                this.$fut.complete(it.body());
            }
            {
                this.$fut = completableFuture;
            }
        });
        String id = this.deployVerticleBlocking(this.vertx, "scriptVerticleWithAsyncStop.kts");
        this.vertx.undeploy(id);
        AssertionsKt.assertEquals$default((Object)id, fut.get(10L, TimeUnit.SECONDS), null, (int)4, null);
    }

    @Test
    public final void testIndirectInheritance() {
        this.deployVerticleBlocking(this.vertx, "singleNonDirectInheritance.kt");
        AssertionsKt.assertEquals$default((Object)"true", (Object)this.vertx.sharedData().getLocalMap("V2").get((Object)"started"), null, (int)4, null);
    }

    @Test
    public final void testIncompleteTypes() {
        this.deployVerticleBlocking(this.vertx, "withAbstractTypes.kt");
        AssertionsKt.assertEquals$default((Object)"true", (Object)this.vertx.sharedData().getLocalMap("V3").get((Object)"started"), null, (int)4, null);
    }

    @Test
    public final void testPrivateTypes() {
        this.vertx.sharedData().getLocalMap("V4").put((Object)"privateStarted", (Object)"false");
        this.deployVerticleBlocking(this.vertx, "privateVerticles.kt");
        AssertionsKt.assertEquals$default((Object)"true", (Object)this.vertx.sharedData().getLocalMap("V4").get((Object)"started"), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"false", (Object)this.vertx.sharedData().getLocalMap("V4").get((Object)"privateStarted"), null, (int)4, null);
    }

    @Test
    public final void testSealedVerticles() {
        this.deployVerticleBlocking(this.vertx, "sealedVerticles.kt");
        AssertionsKt.assertEquals$default((Object)"started", (Object)this.vertx.sharedData().getLocalMap("sealed").get((Object)"V5"), null, (int)4, null);
    }

    @Test
    public final void testPackageSpecified() {
        this.deployVerticleBlocking(this.vertx, "packageSpecified.kt");
        AssertionsKt.assertEquals$default((Object)"started", (Object)this.vertx.sharedData().getLocalMap("P").get((Object)"V"), null, (int)4, null);
    }

    @Test
    public final void testRelativePath() {
        this.deployVerticleBlocking(this.vertx, "src/test/resources/singleVerticle.kt");
    }

    private final String deployVerticleBlocking(@NotNull Vertx $this$deployVerticleBlocking, String name) {
        CompletableFuture fut = new CompletableFuture();
        $this$deployVerticleBlocking.deployVerticle(name, (Handler)new Handler<AsyncResult<String>>(fut){
            final /* synthetic */ CompletableFuture $fut;

            public final void handle(AsyncResult<String> it) {
                if (it.failed()) {
                    this.$fut.completeExceptionally(it.cause());
                } else {
                    this.$fut.complete(it.result());
                }
            }
            {
                this.$fut = completableFuture;
            }
        });
        Object t = fut.get(10L, TimeUnit.SECONDS);
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"fut.get(10L, TimeUnit.SECONDS)");
        return (String)t;
    }

    public KotlinVerticleFactoryTest() {
        Vertx vertx = Vertx.vertx();
        if (vertx == null) {
            Intrinsics.throwNpe();
        }
        this.vertx = vertx;
    }
}

