/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kotlin.coroutines;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.kotlin.coroutines.VertxScheduledFuture;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J6\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u00172\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J(\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J2\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00162\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J6\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00162\u000e\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\u0012\u0010 \u001a\f\u0012\b\u0012\u00060\u0011j\u0002`\u00120!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lio/vertx/kotlin/coroutines/VertxCoroutineExecutor;", "Ljava/util/concurrent/AbstractExecutorService;", "Ljava/util/concurrent/ScheduledExecutorService;", "vertxContext", "Lio/vertx/core/Context;", "(Lio/vertx/core/Context;)V", "getVertxContext", "()Lio/vertx/core/Context;", "awaitTermination", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "execute", "", "command", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "isShutdown", "isTerminated", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "V", "callable", "Ljava/util/concurrent/Callable;", "delay", "scheduleAtFixedRate", "initialDelay", "period", "scheduleWithFixedDelay", "shutdown", "shutdownNow", "", "vertx-lang-kotlin-coroutines"})
final class VertxCoroutineExecutor
extends AbstractExecutorService
implements ScheduledExecutorService {
    @NotNull
    private final Context vertxContext;

    public VertxCoroutineExecutor(@NotNull Context vertxContext) {
        Intrinsics.checkNotNullParameter((Object)vertxContext, (String)"vertxContext");
        this.vertxContext = vertxContext;
    }

    @NotNull
    public final Context getVertxContext() {
        return this.vertxContext;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!Intrinsics.areEqual((Object)Vertx.currentContext(), (Object)this.vertxContext)) {
            this.vertxContext.runOnContext(arg_0 -> VertxCoroutineExecutor.execute$lambda$0(command, arg_0));
        } else {
            command.run();
        }
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        VertxScheduledFuture t = new VertxScheduledFuture(this.vertxContext, command, delay, unit);
        t.schedule();
        return t;
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @Nullable TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    @NotNull
    public <V> ScheduledFuture<V> schedule(@Nullable Callable<V> callable, long delay, @Nullable TimeUnit unit) {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@Nullable Runnable command, long initialDelay, long delay, @Nullable TimeUnit unit) {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    public boolean isTerminated() {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    public boolean isShutdown() {
        throw new UnsupportedOperationException("should not be called");
    }

    @Override
    public boolean awaitTermination(long timeout, @Nullable TimeUnit unit) {
        throw new UnsupportedOperationException("should not be called");
    }

    private static final void execute$lambda$0(Runnable $command, Void it) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        $command.run();
    }
}

