/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.ext.consul.connect

import io.vertx.ext.consul.connect.SidecarServiceOptions
import io.vertx.ext.consul.connect.ProxyOptions

fun sidecarServiceOptionsOf(
  port: Int? = null,
  proxy: io.vertx.ext.consul.connect.ProxyOptions? = null,
  checks: Iterable<io.vertx.core.json.JsonObject>? = null): SidecarServiceOptions = io.vertx.ext.consul.connect.SidecarServiceOptions().apply {

  if (port != null) {
    this.setPort(port)
  }
  if (proxy != null) {
    this.setProxy(proxy)
  }
  if (checks != null) {
    this.setChecks(checks.toList())
  }
}

