/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.ext.auth.webauthn4j

import io.vertx.ext.auth.webauthn4j.WebAuthn4JCredentials

fun webAuthn4JCredentialsOf(
  challenge: String? = null,
  webauthn: io.vertx.core.json.JsonObject? = null,
  username: String? = null,
  origin: String? = null,
  domain: String? = null): WebAuthn4JCredentials = io.vertx.ext.auth.webauthn4j.WebAuthn4JCredentials().apply {

  if (challenge != null) {
    this.setChallenge(challenge)
  }
  if (webauthn != null) {
    this.setWebauthn(webauthn)
  }
  if (username != null) {
    this.setUsername(username)
  }
  if (origin != null) {
    this.setOrigin(origin)
  }
  if (domain != null) {
    this.setDomain(domain)
  }
}

