/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.ext.consul.connect

import io.vertx.ext.consul.connect.UpstreamOptions

fun upstreamOptionsOf(
  destinationName: String? = null,
  dc: String? = null,
  localBindPort: Int? = null): UpstreamOptions = io.vertx.ext.consul.connect.UpstreamOptions().apply {

  if (destinationName != null) {
    this.setDestinationName(destinationName)
  }
  if (dc != null) {
    this.setDc(dc)
  }
  if (localBindPort != null) {
    this.setLocalBindPort(localBindPort)
  }
}

