/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.core.eventbus

import io.vertx.core.eventbus.MessageConsumerOptions

/**
 * A function providing a DSL for building [io.vertx.core.eventbus.MessageConsumerOptions] objects.
 *
 * Options configuring the behavior of a event-bus message consumer.
 *
 * @param address  Set the address the event-bus will register the consumer at.
 * @param localOnly  Set whether the consumer is local only.
 * @param maxBufferedMessages  Set the number of messages this registration will buffer when this stream is paused. The default value is <code>1000</code>. <p> When a new value is set, buffered messages may be discarded to reach the new value. The most recent messages will be kept.
 *
 * <p/>
 * NOTE: This function has been automatically generated from the [io.vertx.core.eventbus.MessageConsumerOptions original] using Vert.x codegen.
 */
fun messageConsumerOptionsOf(
  address: String? = null,
  localOnly: Boolean? = null,
  maxBufferedMessages: Int? = null): MessageConsumerOptions = io.vertx.core.eventbus.MessageConsumerOptions().apply {

  if (address != null) {
    this.setAddress(address)
  }
  if (localOnly != null) {
    this.setLocalOnly(localOnly)
  }
  if (maxBufferedMessages != null) {
    this.setMaxBufferedMessages(maxBufferedMessages)
  }
}

