/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.ext.auth.abac

import io.vertx.ext.auth.abac.Policy

/**
 * A function providing a DSL for building [io.vertx.ext.auth.abac.Policy] objects.
 *
 * Simple definition of ABAC policies. A policy is a set of rules that are evaluated against a set of attributes.
 * On successful evaluation the policy is considered to be satisfied and the listed authorizations are granted.
 *
 * @param name  Set the policy name. This is optional and has no effect on the policy evaluation.
 * @param subjects  Replaces all active subjects with the given set. No <code>subjects</code> implies that the policy applies to all users.
 * @param attributes  Set the attributes of the policy. Attributes are environmental values that are extracted from the .
 * @param authorizations  Set the authorizations of the policy. Authorizations are the actual permissions that are granted to the user. Composite authorizations ( and ) are not allowed in a policy.
 *
 * <p/>
 * NOTE: This function has been automatically generated from the [io.vertx.ext.auth.abac.Policy original] using Vert.x codegen.
 */
fun policyOf(
  name: String? = null,
  subjects: Iterable<String>? = null,
  attributes: Iterable<io.vertx.ext.auth.abac.Attribute>? = null,
  authorizations: Iterable<io.vertx.ext.auth.authorization.Authorization>? = null): Policy = io.vertx.ext.auth.abac.Policy().apply {

  if (name != null) {
    this.setName(name)
  }
  if (subjects != null) {
    this.setSubjects(subjects.toSet())
  }
  if (attributes != null) {
    this.setAttributes(attributes.toSet())
  }
  if (authorizations != null) {
    this.setAuthorizations(authorizations.toSet())
  }
}

