/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.ext.consul.connect

import io.vertx.ext.consul.connect.ExposePathOptions

fun exposePathOptionsOf(
  path: String? = null,
  protocol: String? = null,
  localPathPort: Int? = null,
  listenerPort: Int? = null): ExposePathOptions = io.vertx.ext.consul.connect.ExposePathOptions().apply {

  if (path != null) {
    this.setPath(path)
  }
  if (protocol != null) {
    this.setProtocol(protocol)
  }
  if (localPathPort != null) {
    this.setLocalPathPort(localPathPort)
  }
  if (listenerPort != null) {
    this.setListenerPort(listenerPort)
  }
}

