/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.ext.consul.connect

import io.vertx.ext.consul.connect.ProxyOptions
import io.vertx.ext.consul.connect.ExposeOptions
import io.vertx.ext.consul.connect.UpstreamOptions

fun proxyOptionsOf(
  config: io.vertx.core.json.JsonObject? = null,
  upstreams: Iterable<io.vertx.ext.consul.connect.UpstreamOptions>? = null,
  expose: io.vertx.ext.consul.connect.ExposeOptions? = null): ProxyOptions = io.vertx.ext.consul.connect.ProxyOptions().apply {

  if (config != null) {
    this.setConfig(config)
  }
  if (upstreams != null) {
    this.setUpstreams(upstreams.toList())
  }
  if (expose != null) {
    this.setExpose(expose)
  }
}

