/*
 * Copyright 2019 Red Hat, Inc.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * The Apache License v2.0 is available at
 * http://www.opensource.org/licenses/apache2.0.php
 *
 * You may elect to redistribute this code under either of these licenses.
 */
package io.vertx.kotlin.jdbcclient

import io.vertx.jdbcclient.JDBCConnectOptions
import io.vertx.core.tracing.TracingPolicy
import io.vertx.jdbcclient.FetchDirection
import io.vertx.jdbcclient.ResultSetConcurrency
import io.vertx.jdbcclient.ResultSetType
import io.vertx.jdbcclient.TransactionIsolation

fun jdbcConnectOptionsOf(
  readOnly: Boolean? = null,
  catalog: String? = null,
  transactionIsolation: TransactionIsolation? = null,
  resultSetType: ResultSetType? = null,
  resultSetConcurrency: ResultSetConcurrency? = null,
  autoGeneratedKeys: Boolean? = null,
  schema: String? = null,
  queryTimeout: Int? = null,
  fetchDirection: FetchDirection? = null,
  fetchSize: Int? = null,
  autoGeneratedKeysIndexes: io.vertx.core.json.JsonArray? = null,
  maxRows: Int? = null,
  jdbcUrl: String? = null,
  user: String? = null,
  password: String? = null,
  database: String? = null,
  connectTimeout: Int? = null,
  idleTimeout: Int? = null,
  metricsName: String? = null,
  tracingPolicy: TracingPolicy? = null,
  extraConfig: io.vertx.core.json.JsonObject? = null): JDBCConnectOptions = io.vertx.jdbcclient.JDBCConnectOptions().apply {

  if (readOnly != null) {
    this.setReadOnly(readOnly)
  }
  if (catalog != null) {
    this.setCatalog(catalog)
  }
  if (transactionIsolation != null) {
    this.setTransactionIsolation(transactionIsolation)
  }
  if (resultSetType != null) {
    this.setResultSetType(resultSetType)
  }
  if (resultSetConcurrency != null) {
    this.setResultSetConcurrency(resultSetConcurrency)
  }
  if (autoGeneratedKeys != null) {
    this.setAutoGeneratedKeys(autoGeneratedKeys)
  }
  if (schema != null) {
    this.setSchema(schema)
  }
  if (queryTimeout != null) {
    this.setQueryTimeout(queryTimeout)
  }
  if (fetchDirection != null) {
    this.setFetchDirection(fetchDirection)
  }
  if (fetchSize != null) {
    this.setFetchSize(fetchSize)
  }
  if (autoGeneratedKeysIndexes != null) {
    this.setAutoGeneratedKeysIndexes(autoGeneratedKeysIndexes)
  }
  if (maxRows != null) {
    this.setMaxRows(maxRows)
  }
  if (jdbcUrl != null) {
    this.setJdbcUrl(jdbcUrl)
  }
  if (user != null) {
    this.setUser(user)
  }
  if (password != null) {
    this.setPassword(password)
  }
  if (database != null) {
    this.setDatabase(database)
  }
  if (connectTimeout != null) {
    this.setConnectTimeout(connectTimeout)
  }
  if (idleTimeout != null) {
    this.setIdleTimeout(idleTimeout)
  }
  if (metricsName != null) {
    this.setMetricsName(metricsName)
  }
  if (tracingPolicy != null) {
    this.setTracingPolicy(tracingPolicy)
  }
  if (extraConfig != null) {
    this.setExtraConfig(extraConfig)
  }
}

