/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.ruby;

import io.vertx.codegen.Case;
import io.vertx.codegen.ClassKind;
import io.vertx.codegen.TypeInfo;
import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.lang.ruby.RubyLang;
import io.vertx.docgen.Coordinate;
import io.vertx.docgen.DocGenerator;
import java.beans.Introspector;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class JRubyDocGenerator
implements DocGenerator {
    private TypeInfo.Factory factory;
    private CodeTranslator translator;

    public void init(ProcessingEnvironment processingEnv) {
        this.factory = new TypeInfo.Factory(processingEnv.getElementUtils(), processingEnv.getTypeUtils());
        this.translator = new CodeTranslator(processingEnv);
    }

    public String getName() {
        return "ruby";
    }

    public String renderSource(ExecutableElement elt, String source) {
        RubyLang lang = new RubyLang();
        try {
            return this.translator.translate(elt, (Lang)lang);
        }
        catch (Exception e) {
            System.out.println("Cannot generate " + elt.getEnclosingElement().getSimpleName() + "#" + elt.getSimpleName() + " : " + e.getMessage());
            return "Code not translatable";
        }
    }

    public String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
        TypeInfo type = null;
        try {
            type = this.factory.create(elt.asType());
        }
        catch (Exception e) {
            System.out.println("Could not resolve doc likn for type " + elt.getQualifiedName());
            return null;
        }
        if (type.getKind() == ClassKind.ENUM && ((TypeInfo.Class.Enum)type).isGen()) {
            String baselink = coordinate == null ? "../" : "../../" + coordinate.getArtifactId() + "/";
            return baselink + "enums.html#" + elt.getSimpleName().toString();
        }
        if (type.getKind() == ClassKind.DATA_OBJECT) {
            String baselink = coordinate == null ? "../" : "../../" + coordinate.getArtifactId() + "/";
            return baselink + "dataobjects.html#" + elt.getSimpleName().toString();
        }
        if (type.getKind() == ClassKind.API) {
            String baselink = "";
            if (coordinate != null) {
                baselink = "../../" + coordinate.getArtifactId() + "/ruby/";
            }
            TypeInfo.Class.Api api = (TypeInfo.Class.Api)type.getRaw();
            String module = api.getModuleName();
            String dir = Case.CAMEL.format((Iterable)Case.KEBAB.parse(module));
            return baselink + "yardoc/" + dir + "/" + api.getSimpleName() + ".html";
        }
        return "unavailable";
    }

    public String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
        String baselink = this.resolveTypeLink((TypeElement)elt.getEnclosingElement(), coordinate);
        if (baselink != null) {
            if (baselink.contains("cheatsheet")) {
                baselink = baselink + '#' + Introspector.decapitalize(elt.getSimpleName().toString().substring(3));
            } else {
                String methodName = Case.SNAKE.format((Iterable)Case.CAMEL.parse(elt.getSimpleName().toString()));
                baselink = baselink + '#' + methodName + "-" + (elt.getModifiers().contains((Object)Modifier.STATIC) ? "class_method" : "instance_method");
            }
        }
        return baselink;
    }

    public String resolveConstructorLink(ExecutableElement elt, Coordinate coordinate) {
        return "todo";
    }

    public String resolveFieldLink(VariableElement elt, Coordinate coordinate) {
        return "todo";
    }

    public String resolveLabel(Element elt, String defaultLabel) {
        TypeInfo type;
        if (elt.getKind() == ElementKind.METHOD && (type = this.factory.create(elt.getEnclosingElement().asType())).getKind() == ClassKind.DATA_OBJECT) {
            String name = elt.getSimpleName().toString();
            if (name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                name = Introspector.decapitalize(name.substring(3));
            }
            return name;
        }
        return defaultLabel;
    }
}

