/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.ruby;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class AdaptingMap
extends AbstractMap {
    final Map delegate;
    final Function toRuby;
    final Function toJava;
    final Set<Map.Entry> entrySet = new AbstractSet<Map.Entry>(){

        @Override
        public Iterator<Map.Entry> iterator() {
            final Iterator it = AdaptingMap.this.delegate.entrySet().iterator();
            return new Iterator<Map.Entry>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry next() {
                    final Map.Entry entry = (Map.Entry)it.next();
                    return new Map.Entry(){

                        public Object getKey() {
                            return entry.getKey();
                        }

                        public Object getValue() {
                            return AdaptingMap.this.toRuby.apply(entry.getValue());
                        }

                        public Object setValue(Object value) {
                            return AdaptingMap.this.toRuby.apply(entry.setValue(AdaptingMap.this.toJava.apply(value)));
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return AdaptingMap.this.delegate.size();
        }
    };

    AdaptingMap(Map delegate, Function toRuby, Function toJava) {
        this.delegate = delegate;
        this.toRuby = toRuby;
        this.toJava = toJava;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.delegate.put(key, this.toJava.apply(value));
    }

    @Override
    public Object get(Object key) {
        return this.toRuby.apply(this.delegate.get(key));
    }

    @Override
    public Object remove(Object key) {
        return this.toRuby.apply(this.delegate.remove(key));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<Map.Entry> entrySet() {
        return this.entrySet;
    }
}

