/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.ruby;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.lang.ruby.Deployment;
import io.vertx.lang.ruby.JRubyVerticleFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jruby.RubyClass;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;

class ContainerHolder {
    private static final AtomicInteger seq = new AtomicInteger();
    private final JRubyVerticleFactory factory;
    private final String verticleName;
    private ScriptingContainer container;
    private int refs;

    ContainerHolder(JRubyVerticleFactory factory, String verticleName) {
        this.factory = factory;
        this.verticleName = verticleName;
    }

    String getVerticleName() {
        return this.verticleName;
    }

    synchronized Deployment create(String gemPath, Vertx vertx, ClassLoader classLoader, Future<?> startFuture) {
        if (this.refs++ == 0) {
            ScriptingContainer cont = new ScriptingContainer(LocalContextScope.SINGLETHREAD);
            RubyInstanceConfig config = cont.getProvider().getRubyInstanceConfig();
            if (gemPath != null) {
                HashMap<String, String> newEnv = new HashMap<String, String>(config.getEnvironment());
                newEnv.put("GEM_PATH", gemPath);
                config.setEnvironment(newEnv);
            }
            if (classLoader instanceof URLClassLoader) {
                config.setLoadPaths(Arrays.stream(((URLClassLoader)classLoader).getURLs()).map(u -> {
                    String form = u.toExternalForm();
                    if (form.endsWith(".jar")) {
                        return "jar:" + form + "!";
                    }
                    return form;
                }).collect(Collectors.toList()));
            }
            cont.setClassLoader(classLoader);
            cont.setError(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }));
            cont.put("$_vertx", (Object)vertx);
            cont.runScriptlet("require 'vertx/vertx'");
            cont.runScriptlet("require 'vertx/future'");
            cont.runScriptlet("$vertx=Vertx::Vertx.new($_vertx)");
            cont.remove("$_vertx");
            this.container = cont;
        }
        try {
            String modName = "Mod___VertxInternalVert__" + seq.incrementAndGet();
            StringBuilder script = new StringBuilder("require 'vertx/util/vertx_require'\n").append("module ").append(modName).append(";extend self;");
            URL url = classLoader.getResource(this.verticleName);
            if (url == null) {
                File f = new File(this.verticleName);
                if (!f.isAbsolute()) {
                    f = new File(System.getProperty("user.dir"), this.verticleName);
                }
                if (f.exists() && f.isFile()) {
                    url = f.toURI().toURL();
                }
            }
            if (url == null) {
                throw new IllegalStateException("Cannot find verticle script: " + this.verticleName + " on classpath");
            }
            int idx = this.verticleName.lastIndexOf(47);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = br.readLine();
            while (line != null) {
                script.append(line).append("\n");
                line = br.readLine();
            }
            br.close();
            script.append(";end;").append(modName);
            RubyModule wrappingModule = (RubyModule)this.container.runScriptlet((Reader)new StringReader(script.toString()), this.verticleName.substring(idx + 1));
            if (wrappingModule.getMethods().containsKey("vertx_start")) {
                this.container.callMethod((Object)wrappingModule, "vertx_start", new Object[0]);
                startFuture.complete();
            } else if (wrappingModule.getMethods().containsKey("vertx_start_async")) {
                this.invokeAsync(wrappingModule, "vertx_start_async", startFuture);
            } else {
                startFuture.complete();
            }
            return new Deployment(modName, wrappingModule);
        }
        catch (Throwable t) {
            startFuture.fail(t);
            return null;
        }
    }

    synchronized void undeploy(Deployment deployment, Future<?> stopFuture) {
        Future fut = Future.future();
        fut.setHandler(ar -> {
            this.container.runScriptlet("Object.send(:remove_const, :" + deployment.modName + ")");
            if (--this.refs == 0) {
                this.factory.removeVerticle(this);
                this.container.terminate();
            }
            if (ar.succeeded()) {
                stopFuture.complete();
            } else {
                stopFuture.fail(ar.cause());
            }
        });
        if (deployment.wrappingModule.getMethods().containsKey("vertx_stop")) {
            this.container.callMethod((Object)deployment.wrappingModule, "vertx_stop", new Object[0]);
            fut.complete();
        } else if (deployment.wrappingModule.getMethods().containsKey("vertx_stop_async")) {
            this.invokeAsync(deployment.wrappingModule, "vertx_stop_async", fut);
        } else {
            fut.complete();
        }
    }

    private void invokeAsync(RubyModule module, String name, Future future) {
        RubyClass rubyClass = (RubyClass)this.container.runScriptlet("return ::Vertx::Future");
        Object wrappedFuture = this.container.callMethod((Object)rubyClass, "new", new Object[]{future});
        this.container.callMethod((Object)module, name, new Object[]{wrappedFuture});
    }
}

