require 'vertx-web/sock_js_socket'
require 'vertx-bridge-common/base_bridge_event'
require 'vertx/future'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.sockjs.BridgeEvent
module VertxWeb
  #  Represents an event that occurs on the event bus bridge.
  #  <p>
  #  Please consult the documentation for a full explanation.
  class BridgeEvent < ::VertxBridgeCommon::BaseBridgeEvent
    # @private
    # @param j_del [::VertxWeb::BridgeEvent] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::BridgeEvent] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == BridgeEvent
    end
    def @@j_api_type.wrap(obj)
      BridgeEvent.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandlerSockjs::BridgeEvent.java_class
    end
    #  Has the future completed?
    #  <p>
    #  It's completed if it's either succeeded or failed.
    # @return [true,false] true if completed, false if not
    def complete?
      if !block_given?
        return @j_del.java_method(:isComplete, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling complete?()"
    end
    #  Set a handler for the result.
    #  <p>
    #  If the future has already been completed it will be called immediately. Otherwise it will be called when the
    #  future is completed.
    # @yield the Handler that will be called with the result
    # @return [self]
    def set_handler
      if block_given?
        @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_handler()"
    end
    #  Set the result. Any handler will be called, if there is one, and the future will be marked as completed.
    # @param [true,false] result the result
    # @return [void]
    def complete(result=nil)
      if !block_given? && result == nil
        return @j_del.java_method(:complete, []).call()
      elsif (result.class == TrueClass || result.class == FalseClass) && !block_given?
        return @j_del.java_method(:complete, [Java::JavaLang::Boolean.java_class]).call(result)
      end
      raise ArgumentError, "Invalid arguments when calling complete(#{result})"
    end
    #  Try to set the failure. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
    # @overload fail(cause)
    #   @param [Exception] cause the failure cause
    # @overload fail(failureMessage)
    #   @param [String] failureMessage the failure message
    # @return [void]
    def fail(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return @j_del.java_method(:fail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1))
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:fail, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling fail(#{param_1})"
    end
    #  Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
    # @param [true,false] result the result
    # @return [true,false] false when the future is already completed
    def try_complete?(result=nil)
      if !block_given? && result == nil
        return @j_del.java_method(:tryComplete, []).call()
      elsif (result.class == TrueClass || result.class == FalseClass) && !block_given?
        return @j_del.java_method(:tryComplete, [Java::JavaLang::Boolean.java_class]).call(result)
      end
      raise ArgumentError, "Invalid arguments when calling try_complete?(#{result})"
    end
    #  Try to set the failure. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
    # @overload tryFail(cause)
    #   @param [Exception] cause the failure cause
    # @overload tryFail(failureMessage)
    #   @param [String] failureMessage the failure message
    # @return [true,false] false when the future is already completed
    def try_fail?(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return @j_del.java_method(:tryFail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1))
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:tryFail, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling try_fail?(#{param_1})"
    end
    #  The result of the operation. This will be null if the operation failed.
    # @return [true,false] the result or null if the operation failed.
    def result?
      if !block_given?
        return @j_del.java_method(:result, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling result?()"
    end
    #  A Throwable describing failure. This will be null if the operation succeeded.
    # @return [Exception] the cause or null if the operation succeeded.
    def cause
      if !block_given?
        return ::Vertx::Util::Utils.from_throwable(@j_del.java_method(:cause, []).call())
      end
      raise ArgumentError, "Invalid arguments when calling cause()"
    end
    #  Did it succeed?
    # @return [true,false] true if it succeded or false otherwise
    def succeeded?
      if !block_given?
        return @j_del.java_method(:succeeded, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling succeeded?()"
    end
    #  Did it fail?
    # @return [true,false] true if it failed or false otherwise
    def failed?
      if !block_given?
        return @j_del.java_method(:failed, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling failed?()"
    end
    #  Compose this future with a provided <code>next</code> future.<p>
    # 
    #  When this (the one on which <code>compose</code> is called) future succeeds, the <code>handler</code> will be called with
    #  the completed value, this handler should complete the next future.<p>
    # 
    #  If the <code>handler</code> throws an exception, the returned future will be failed with this exception.<p>
    # 
    #  When this future fails, the failure will be propagated to the <code>next</code> future and the <code>handler</code>
    #  will not be called.
    # @overload compose(mapper)
    #   @yield the mapper function
    # @overload compose(handler,next)
    #   @param [Proc] handler the handler
    #   @param [::Vertx::Future] _next the next future
    # @return [::Vertx::Future] the next future, used for chaining
    def compose(param_1=nil,param_2=nil)
      if block_given? && param_1 == nil && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:compose, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(event).j_del })),::Vertx::Future, nil)
      elsif param_1.class == Proc && param_2.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:compose, [Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Future.java_class]).call((Proc.new { |event| param_1.call(event) }),param_2.j_del),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling compose(#{param_1},#{param_2})"
    end
    #  Map the result of a future to a specific <code>value</code>.<p>
    # 
    #  When this future succeeds, this <code>value</code> will complete the future returned by this method call.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future.
    # @overload map(mapper)
    #   @yield the mapper function
    # @overload map(value)
    #   @param [Object] value the value that eventually completes the mapped future
    # @return [::Vertx::Future] the mapped future
    def map(param_1=nil)
      if block_given? && param_1 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:map, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(event)) })),::Vertx::Future, nil)
      elsif ::Vertx::Util::unknown_type.accept?(param_1) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:map, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(param_1)),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling map(#{param_1})"
    end
    #  Map the result of a future to <code>null</code>.<p>
    # 
    #  This is a conveniency for <code>future.map((T) null)</code> or <code>future.map((Void) null)</code>.<p>
    # 
    #  When this future succeeds, <code>null</code> will complete the future returned by this method call.<p>
    # 
    #  When this future fails, the failure will be propagated to the returned future.
    # @return [::Vertx::Future] the mapped future
    def map_empty
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:mapEmpty, []).call(),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling map_empty()"
    end
    # @return [Proc] an handler completing this future
    def completer
      if !block_given?
        if @cached_completer != nil
          return @cached_completer
        end
        return @cached_completer = ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:completer, []).call()) { |val| val }
      end
      raise ArgumentError, "Invalid arguments when calling completer()"
    end
    #  Handles a failure of this Future by returning the result of another Future.
    #  If the mapper fails, then the returned future will be failed with this failure.
    # @yield A function which takes the exception of a failure and returns a new future.
    # @return [::Vertx::Future] A recovered future
    def recover(mapper=nil)
      if block_given? && mapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:recover, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del })),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling recover(#{mapper})"
    end
    #  Map the failure of a future to a specific <code>value</code>.<p>
    # 
    #  When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
    # 
    #  When this future succeeds, the result will be propagated to the returned future.
    # @overload otherwise(mapper)
    #   @yield the mapper function
    # @overload otherwise(value)
    #   @param [true,false] value the value that eventually completes the mapped future
    # @return [::Vertx::Future] the mapped future
    def otherwise(param_1=nil)
      if block_given? && param_1 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) })),::Vertx::Future, nil)
      elsif (param_1.class == TrueClass || param_1.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::JavaLang::Boolean.java_class]).call(param_1),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling otherwise(#{param_1})"
    end
    #  Map the failure of a future to <code>null</code>.<p>
    # 
    #  This is a convenience for <code>future.otherwise((T) null)</code>.<p>
    # 
    #  When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
    # 
    #  When this future succeeds, the result will be propagated to the returned future.
    # @return [::Vertx::Future] the mapped future
    def otherwise_empty
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwiseEmpty, []).call(),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling otherwise_empty()"
    end
    # @return [:SOCKET_CREATED,:SOCKET_CLOSED,:SOCKET_IDLE,:SOCKET_PING,:SEND,:PUBLISH,:RECEIVE,:REGISTER,:UNREGISTER] the type of the event
    def type
      if !block_given?
        if @cached_type != nil
          return @cached_type
        end
        return @cached_type = @j_del.java_method(:type, []).call().name.intern
      end
      raise ArgumentError, "Invalid arguments when calling type()"
    end
    #  Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
    #  no message involved. If the returned message is modified, {::VertxWeb::BridgeEvent#set_raw_message} should be called with the
    #  new message.
    # @return [Hash{String => Object}] the raw JSON message for the event
    def get_raw_message
      if !block_given?
        return @j_del.java_method(:getRawMessage, []).call() != nil ? JSON.parse(@j_del.java_method(:getRawMessage, []).call().encode) : nil
      end
      raise ArgumentError, "Invalid arguments when calling get_raw_message()"
    end
    #  Get the raw JSON message for the event. This will be null for SOCKET_CREATED or SOCKET_CLOSED events as there is
    #  no message involved.
    # @param [Hash{String => Object}] message the raw message
    # @return [self]
    def set_raw_message(message=nil)
      if message.class == Hash && !block_given?
        @j_del.java_method(:setRawMessage, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(message))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_raw_message(#{message})"
    end
    #  Get the SockJSSocket instance corresponding to the event
    # @return [::VertxWeb::SockJSSocket] the SockJSSocket instance
    def socket
      if !block_given?
        if @cached_socket != nil
          return @cached_socket
        end
        return @cached_socket = ::Vertx::Util::Utils.safe_create(@j_del.java_method(:socket, []).call(),::VertxWeb::SockJSSocket)
      end
      raise ArgumentError, "Invalid arguments when calling socket()"
    end
  end
end
