require 'vertx/vertx'
require 'vertx-cassandra/result_set'
require 'vertx-cassandra/cassandra_row_stream'
require 'vertx/util/utils.rb'
# Generated from io.vertx.cassandra.CassandraClient
module VertxCassandra
  #  Eclipse Vert.x Cassandra client.
  class CassandraClient
    # @private
    # @param j_del [::VertxCassandra::CassandraClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxCassandra::CassandraClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == CassandraClient
    end
    def @@j_api_type.wrap(obj)
      CassandraClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCassandra::CassandraClient.java_class
    end
    #  Create a Cassandra client which maintains its own data source.
    #  <p>
    #  It is not recommended to create several non shared clients in an application.
    #  Your application should either use only single non shared client, or use shared client.
    #  This is because {::VertxCassandra::CassandraClient} backed by Session.
    #  And Datastax does not recommended to have several Session
    #  instances. Better to have only one, and share it.
    # @param [::Vertx::Vertx] vertx the Vert.x instance
    # @param [Hash] cassandraClientOptions the options
    # @return [::VertxCassandra::CassandraClient] the client
    def self.create_non_shared(vertx=nil,cassandraClientOptions=nil)
      if vertx.class.method_defined?(:j_del) && !block_given? && cassandraClientOptions == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createNonShared, [Java::IoVertxCore::Vertx.java_class]).call(vertx.j_del),::VertxCassandra::CassandraClient)
      elsif vertx.class.method_defined?(:j_del) && cassandraClientOptions.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createNonShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCassandra::CassandraClientOptions.java_class]).call(vertx.j_del,Java::IoVertxCassandra::CassandraClientOptions.new(::Vertx::Util::Utils.to_json_object(cassandraClientOptions))),::VertxCassandra::CassandraClient)
      end
      raise ArgumentError, "Invalid arguments when calling create_non_shared(#{vertx},#{cassandraClientOptions})"
    end
    #  Create a Cassandra client which shares its data source with any other Cassandra clients created with the same
    #  data source name.
    # @overload createShared(vertx)
    #   @param [::Vertx::Vertx] vertx 
    # @overload createShared(vertx,datasourceName)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] datasourceName 
    # @overload createShared(vertx,cassandraClientOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash] cassandraClientOptions 
    # @overload createShared(vertx,datasourceName,cassandraClientOptions)
    #   @param [::Vertx::Vertx] vertx the Vert.x instance
    #   @param [String] datasourceName the data source name
    #   @param [Hash] cassandraClientOptions the options
    # @return [::VertxCassandra::CassandraClient] the client
    def self.create_shared(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class.method_defined?(:j_del) && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class]).call(param_1.j_del),::VertxCassandra::CassandraClient)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(param_1.j_del,param_2),::VertxCassandra::CassandraClient)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCassandra::CassandraClientOptions.java_class]).call(param_1.j_del,Java::IoVertxCassandra::CassandraClientOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxCassandra::CassandraClient)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && param_3.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCassandra::CassandraClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCassandra::CassandraClientOptions.java_class]).call(param_1.j_del,param_2,Java::IoVertxCassandra::CassandraClientOptions.new(::Vertx::Util::Utils.to_json_object(param_3))),::VertxCassandra::CassandraClient)
      end
      raise ArgumentError, "Invalid arguments when calling create_shared(#{param_1},#{param_2},#{param_3})"
    end
    #  Connect to a Cassandra service.
    # @param [String] keyspace The name of the keyspace to use for the created connection.
    # @yield handler called when asynchronous connect call ends
    # @return [self]
    def connect(keyspace=nil)
      if !block_given? && keyspace == nil
        @j_del.java_method(:connect, []).call()
        return self
      elsif block_given? && keyspace == nil
        @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      elsif keyspace.class == String && block_given?
        @j_del.java_method(:connect, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(keyspace,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling connect(#{keyspace})"
    end
    # @return [true,false] whether this Cassandra client instance connected.
    def connected?
      if !block_given?
        return @j_del.java_method(:isConnected, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling connected?()"
    end
    #  Execute the query and provide a handler for consuming results.
    # @param [String] query the query to execute
    # @yield handler called when result of execution is present, but can be not fully fetched
    # @return [self]
    def execute(query=nil)
      if query.class == String && block_given?
        @j_del.java_method(:execute, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(query,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxCassandra::ResultSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling execute(#{query})"
    end
    #  Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
    # @param [String] sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
    # @yield the handler which is called once the operation completes. It will return an instance of {::VertxCassandra::CassandraRowStream}.
    # @return [self]
    def query_stream(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:queryStream, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxCassandra::CassandraRowStream) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query_stream(#{sql})"
    end
    #  Disconnects from the Cassandra service.
    # @yield handler called when asynchronous disconnect call ends
    # @return [self]
    def disconnect
      if !block_given?
        @j_del.java_method(:disconnect, []).call()
        return self
      elsif block_given?
        @j_del.java_method(:disconnect, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling disconnect()"
    end
    #  The name of the default pool
    def self.DEFAULT_POOL_NAME
      Java::IoVertxCassandra::CassandraClient.DEFAULT_POOL_NAME
    end
  end
end
