require 'vertx-jdbc/jdbc_client'
require 'vertx/vertx'
require 'vertx-auth-common/auth_provider'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.jdbc.JDBCAuth
module VertxAuthJdbc
  #  Factory interface for creating {::VertxAuthCommon::AuthProvider} instances that use the Vert.x JDBC client.
  # 
  #  By default the hashing strategy is SHA-512. If you're already running in production this is backwards
  #  compatible, however for new deployments or security upgrades it is recommended to use the PBKDF2 strategy
  #  as it is the current OWASP recommendation for password storage.
  class JDBCAuth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthJdbc::JDBCAuth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthJdbc::JDBCAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == JDBCAuth
    end
    def @@j_api_type.wrap(obj)
      JDBCAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthJdbc::JDBCAuth.java_class
    end
    #  Authenticate a user.
    #  <p>
    #  The first argument is a JSON object containing information for authenticating the user. What this actually contains
    #  depends on the specific implementation. In the case of a simple username/password based
    #  authentication it is likely to contain a JSON object with the following structure:
    #  <pre>
    #    {
    #      "username": "tim",
    #      "password": "mypassword"
    #    }
    #  </pre>
    #  For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
    #  <p>
    #  If the user is successfully authenticated a  object is passed to the handler in an {AsyncResult}.
    #  The user object can then be used for authorisation.
    # @param [Hash{String => Object}] authInfo The auth information
    # @yield The result handler
    # @return [void]
    def authenticate(authInfo=nil)
      if authInfo.class == Hash && block_given?
        return @j_del.java_method(:authenticate, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(authInfo),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthCommon::User) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling authenticate(#{authInfo})"
    end
    #  Create a JDBC auth provider implementation
    # @param [::Vertx::Vertx] vertx 
    # @param [::VertxJdbc::JDBCClient] client the JDBC client instance
    # @return [::VertxAuthJdbc::JDBCAuth] the auth provider
    def self.create(vertx=nil,client=nil)
      if vertx.class.method_defined?(:j_del) && client.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthJdbc::JDBCAuth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtJdbc::JDBCClient.java_class]).call(vertx.j_del,client.j_del),::VertxAuthJdbc::JDBCAuth)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{vertx},#{client})"
    end
    #  Set the authentication query to use. Use this if you want to override the default authentication query.
    # @param [String] authenticationQuery the authentication query
    # @return [self]
    def set_authentication_query(authenticationQuery=nil)
      if authenticationQuery.class == String && !block_given?
        @j_del.java_method(:setAuthenticationQuery, [Java::java.lang.String.java_class]).call(authenticationQuery)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_authentication_query(#{authenticationQuery})"
    end
    #  Set the roles query to use. Use this if you want to override the default roles query.
    # @param [String] rolesQuery the roles query
    # @return [self]
    def set_roles_query(rolesQuery=nil)
      if rolesQuery.class == String && !block_given?
        @j_del.java_method(:setRolesQuery, [Java::java.lang.String.java_class]).call(rolesQuery)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_roles_query(#{rolesQuery})"
    end
    #  Set the permissions query to use. Use this if you want to override the default permissions query.
    # @param [String] permissionsQuery the permissions query
    # @return [self]
    def set_permissions_query(permissionsQuery=nil)
      if permissionsQuery.class == String && !block_given?
        @j_del.java_method(:setPermissionsQuery, [Java::java.lang.String.java_class]).call(permissionsQuery)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_permissions_query(#{permissionsQuery})"
    end
    #  Set the role prefix to distinguish from permissions when checking for isPermitted requests.
    # @param [String] rolePrefix a Prefix e.g.: "role:"
    # @return [self]
    def set_role_prefix(rolePrefix=nil)
      if rolePrefix.class == String && !block_given?
        @j_del.java_method(:setRolePrefix, [Java::java.lang.String.java_class]).call(rolePrefix)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_role_prefix(#{rolePrefix})"
    end
    #  Compute the hashed password given the unhashed password and the salt
    # 
    #  The implementation relays to the JDBCHashStrategy provided.
    # @param [String] password the unhashed password
    # @param [String] salt the salt
    # @param [Fixnum] version the nonce version to use
    # @return [String] the hashed password
    def compute_hash(password=nil,salt=nil,version=nil)
      if password.class == String && salt.class == String && !block_given? && version == nil
        return @j_del.java_method(:computeHash, [Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(password,salt)
      elsif password.class == String && salt.class == String && version.class == Fixnum && !block_given?
        return @j_del.java_method(:computeHash, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::int.java_class]).call(password,salt,version)
      end
      raise ArgumentError, "Invalid arguments when calling compute_hash(#{password},#{salt},#{version})"
    end
    #  Compute a salt string.
    # 
    #  The implementation relays to the JDBCHashStrategy provided.
    # @return [String] a non null salt value
    def generate_salt
      if !block_given?
        return @j_del.java_method(:generateSalt, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling generate_salt()"
    end
    #  Provide a application configuration level on hash nonce's as a ordered list of
    #  nonces where each position corresponds to a version.
    # 
    #  The nonces are supposed not to be stored in the underlying jdbc storage but to
    #  be provided as a application configuration. The idea is to add one extra variable
    #  to the hash function in order to make breaking the passwords using rainbow tables
    #  or precomputed hashes harder. Leaving the attacker only with the brute force
    #  approach.
    # 
    #  The implementation relays to the JDBCHashStrategy provided.
    # @param [Array<String,Object>] nonces a List of non null Strings.
    # @return [self]
    def set_nonces(nonces=nil)
      if nonces.class == Array && !block_given?
        @j_del.java_method(:setNonces, [Java::IoVertxCoreJson::JsonArray.java_class]).call(::Vertx::Util::Utils.to_json_array(nonces))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_nonces(#{nonces})"
    end
    #  The default query to be used for authentication
    def self.DEFAULT_AUTHENTICATE_QUERY
      Java::IoVertxExtAuthJdbc::JDBCAuth.DEFAULT_AUTHENTICATE_QUERY
    end
    #  The default query to retrieve all roles for the user
    def self.DEFAULT_ROLES_QUERY
      Java::IoVertxExtAuthJdbc::JDBCAuth.DEFAULT_ROLES_QUERY
    end
    #  The default query to retrieve all permissions for the role
    def self.DEFAULT_PERMISSIONS_QUERY
      Java::IoVertxExtAuthJdbc::JDBCAuth.DEFAULT_PERMISSIONS_QUERY
    end
    #  The default role prefix
    def self.DEFAULT_ROLE_PREFIX
      Java::IoVertxExtAuthJdbc::JDBCAuth.DEFAULT_ROLE_PREFIX
    end
  end
end
