require 'vertx-amqp-client/amqp_message'
require 'vertx-amqp-client/amqp_sender'
require 'vertx-amqp-client/amqp_receiver'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpConnection
module VertxAmqpClient
  #  Once connected to the broker or router, you get a connection. This connection is automatically opened.
  class AmqpConnection
    # @private
    # @param j_del [::VertxAmqpClient::AmqpConnection] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpConnection
    end
    def @@j_api_type.wrap(obj)
      AmqpConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpConnection.java_class
    end
    #  Registers a handler called on disconnection.
    # @yield the exception handler.
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    #  Closes the AMQP connection, i.e. allows the Close frame to be emitted.
    # @yield the close handler notified when the connection is closed. May be <code>null</code>.
    # @return [self]
    def close
      if block_given?
        @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Creates a receiver used to consumer messages from the given address.
    # @overload createReceiver(address,completionHandler)
    #   @param [String] address The source address to attach the consumer to, must not be <code>null</code>
    #   @yield the handler called with the receiver. The receiver has been opened.
    # @overload createReceiver(address,messageHandler,completionHandler)
    #   @param [String] address The source address to attach the consumer to, must not be <code>null</code>
    #   @param [Proc] messageHandler The message handler, must not be <code>null</code>
    #   @yield the handler called with the receiver that has been opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
    # @overload createReceiver(address,receiverOptions,completionHandler)
    #   @param [String] address The source address to attach the consumer to.
    #   @param [Hash] receiverOptions The options for this receiver.
    #   @yield The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
    # @overload createReceiver(address,receiverOptions,messageHandler,completionHandler)
    #   @param [String] address The source address to attach the consumer to.
    #   @param [Hash] receiverOptions The options for this receiver.
    #   @param [Proc] messageHandler The message handler, must not be <code>null</code>
    #   @yield The handler called with the receiver, once opened. Note that the <code>messageHandler</code> can be called before the <code>completionHandler</code> if messages are awaiting delivery.
    # @return [self]
    def create_receiver(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == String && block_given? && param_2 == nil && param_3 == nil
        @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) }))
        return self
      elsif param_1.class == String && param_2.class == Proc && block_given? && param_3 == nil
        @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,(Proc.new { |event| param_2.call(::Vertx::Util::Utils.safe_create(event,::VertxAmqpClient::AmqpMessage)) }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) }))
        return self
      elsif param_1.class == String && param_2.class == Hash && block_given? && param_3 == nil
        @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpReceiverOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,Java::IoVertxAmqp::AmqpReceiverOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) }))
        return self
      elsif param_1.class == String && param_2.class == Hash && param_3.class == Proc && block_given?
        @j_del.java_method(:createReceiver, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpReceiverOptions.java_class,Java::IoVertxCore::Handler.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1,Java::IoVertxAmqp::AmqpReceiverOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),(Proc.new { |event| param_3.call(::Vertx::Util::Utils.safe_create(event,::VertxAmqpClient::AmqpMessage)) }),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_receiver(#{param_1},#{param_2},#{param_3})"
    end
    #  Creates a dynamic receiver. The address is provided by the broker and is available in the <code>completionHandler</code>,
    #  using the {::VertxAmqpClient::AmqpReceiver#address} method. this method is useful for request-reply to generate a unique
    #  reply address.
    # @yield the completion handler, called when the receiver has been created and opened.
    # @return [self]
    def create_dynamic_receiver
      if block_given?
        @j_del.java_method(:createDynamicReceiver, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpReceiver) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_dynamic_receiver()"
    end
    #  Creates a sender used to send messages to the given address. The address must be set. For anonymous sender, check
    #  {::VertxAmqpClient::AmqpConnection#create_anonymous_sender}.
    # @param [String] address The target address to attach to, allowed to be <code>null</code> if the <code>options</code> configures the sender to be attached to a dynamic address (provided by the broker).
    # @param [Hash] options The AMQP sender options
    # @yield The handler called with the sender, once opened
    # @return [self]
    def create_sender(address=nil,options=nil)
      if address.class == String && block_given? && options == nil
        @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(address,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) }))
        return self
      elsif address.class == String && options.class == Hash && block_given?
        @j_del.java_method(:createSender, [Java::java.lang.String.java_class,Java::IoVertxAmqp::AmqpSenderOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(address,Java::IoVertxAmqp::AmqpSenderOptions.new(::Vertx::Util::Utils.to_json_object(options)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_sender(#{address},#{options})"
    end
    #  Creates an anonymous sender.
    #  <p>
    #  Unlike "regular" sender, this sender is not associated to a specific address, and each message sent must provide
    #  an address. This method can be used in request-reply scenarios where you create a sender to send the reply,
    #  but you don't know the address, as the reply address is passed into the message you are going to receive.
    # @yield The handler called with the created sender, once opened
    # @return [self]
    def create_anonymous_sender
      if block_given?
        @j_del.java_method(:createAnonymousSender, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAmqpClient::AmqpSender) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_anonymous_sender()"
    end
  end
end
