require 'vertx-sql-client/sql_connection'
require 'vertx/vertx'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/transaction'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.pgclient.PgConnection
module VertxPgClient
  #  A connection to Postgres.
  class PgConnection < ::VertxSqlClient::SqlConnection
    # @private
    # @param j_del [::VertxPgClient::PgConnection] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxPgClient::PgConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PgConnection
    end
    def @@j_api_type.wrap(obj)
      PgConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxPgclient::PgConnection.java_class
    end
    #  Begin a transaction and returns a  for controlling and tracking
    #  this transaction.
    #  <p/>
    #  When the connection is explicitely closed, any inflight transaction is rollbacked.
    # @return [::VertxSqlClient::Transaction] the transaction instance
    def begin
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:begin, []).call(),::VertxSqlClient::Transaction)
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    # @return [true,false] whether the connection uses SSL
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSSL, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling ssl?()"
    end
    #  Close the current connection after all the pending commands have been processed.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Like {::VertxPgClient::PgConnection#connect} with options build from <code>connectionUri</code>.
    # @overload connect(vertx,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @yield 
    # @overload connect(vertx,options,handler)
    #   @param [::Vertx::Vertx] vertx the vertx instance
    #   @param [Hash] options the connect options
    #   @yield the handler called with the connection or the failure
    # @overload connect(vertx,connectionUri,handler)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @yield 
    # @return [void]
    def self.connect(param_1=nil,param_2=nil)
      if param_1.class.method_defined?(:j_del) && block_given? && param_2 == nil
        return Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) }))
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && block_given?
        return Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxPgclient::PgConnectOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,Java::IoVertxPgclient::PgConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) }))
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && block_given?
        return Java::IoVertxPgclient::PgConnection.java_method(:connect, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(param_1.j_del,param_2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxPgClient::PgConnection) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling connect(#{param_1},#{param_2})"
    end
    #  Set an handler called when the connection receives notification on a channel.
    #  <p/>
    #  The handler is called with the {Hash} and has access to the channel name
    #  and the notification payload.
    # @yield the handler
    # @return [self]
    def notification_handler
      if block_given?
        @j_del.java_method(:notificationHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.toJson.encode) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling notification_handler()"
    end
    #  Send a request cancellation message to tell the server to cancel processing request in this connection.
    #  <br>Note: Use this with caution because the cancellation signal may or may not have any effect.
    # @yield the handler notified if cancelling request is sent
    # @return [::VertxPgClient::PgConnection] a reference to this, so the API can be used fluently
    def cancel_request
      if block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cancelRequest, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) })),::VertxPgClient::PgConnection)
      end
      raise ArgumentError, "Invalid arguments when calling cancel_request()"
    end
    # @return [Fixnum] The process ID of the target backend
    def process_id
      if !block_given?
        return @j_del.java_method(:processId, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling process_id()"
    end
    # @return [Fixnum] The secret key for the target backend
    def secret_key
      if !block_given?
        return @j_del.java_method(:secretKey, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling secret_key()"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def prepare(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepare(#{sql})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def close_handler
      if block_given?
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close_handler()"
    end
    # @param [String] sql 
    # @param [::VertxSqlClient::Tuple] arguments 
    # @yield 
    # @return [self]
    def prepared_query(sql=nil,arguments=nil)
      if sql.class == String && block_given? && arguments == nil
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      elsif sql.class == String && arguments.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,arguments.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql},#{arguments})"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def query(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    # @param [String] sql 
    # @param [Array<::VertxSqlClient::Tuple>] batch 
    # @yield 
    # @return [self]
    def prepared_batch(sql=nil,batch=nil)
      if sql.class == String && batch.class == Array && block_given?
        @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,batch.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_batch(#{sql},#{batch})"
    end
  end
end
