require 'vertx-sql-client/sql_client'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Transaction
module VertxSqlClient
  #  A transaction that allows to control the transaction and receive events.
  class Transaction < ::VertxSqlClient::SqlClient
    # @private
    # @param j_del [::VertxSqlClient::Transaction] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Transaction] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Transaction
    end
    def @@j_api_type.wrap(obj)
      Transaction.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Transaction.java_class
    end
    #  Create a prepared query.
    # @param [String] sql the sql
    # @yield the handler notified with the prepared query asynchronously
    # @return [self]
    def prepare(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepare(#{sql})"
    end
    #  Like {::VertxSqlClient::Transaction#commit} with an handler to be notified when the transaction commit has completed
    # @yield 
    # @return [void]
    def commit
      if !block_given?
        return @j_del.java_method(:commit, []).call()
      elsif block_given?
        return @j_del.java_method(:commit, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling commit()"
    end
    #  Like {::VertxSqlClient::Transaction#rollback} with an handler to be notified when the transaction rollback has completed
    # @yield 
    # @return [void]
    def rollback
      if !block_given?
        return @j_del.java_method(:rollback, []).call()
      elsif block_given?
        return @j_del.java_method(:rollback, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling rollback()"
    end
    #  Set an handler to be called when the transaction is aborted.
    # @yield the handler
    # @return [self]
    def abort_handler
      if block_given?
        @j_del.java_method(:abortHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling abort_handler()"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def query(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    # @param [String] sql 
    # @param [::VertxSqlClient::Tuple] arguments 
    # @yield 
    # @return [self]
    def prepared_query(sql=nil,arguments=nil)
      if sql.class == String && block_given? && arguments == nil
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      elsif sql.class == String && arguments.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,arguments.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql},#{arguments})"
    end
    # @param [String] sql 
    # @param [Array<::VertxSqlClient::Tuple>] batch 
    # @yield 
    # @return [self]
    def prepared_batch(sql=nil,batch=nil)
      if sql.class == String && batch.class == Array && block_given?
        @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,batch.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_batch(#{sql},#{batch})"
    end
    #  Rollback the transaction and release the associated resources.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
