require 'vertx-sql-client/row_stream'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/cursor'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.PreparedQuery
module VertxSqlClient
  #  A prepared query.
  class PreparedQuery
    # @private
    # @param j_del [::VertxSqlClient::PreparedQuery] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::PreparedQuery] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PreparedQuery
    end
    def @@j_api_type.wrap(obj)
      PreparedQuery.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::PreparedQuery.java_class
    end
    #  Create a cursor with the provided <code>arguments</code>.
    # @param [::VertxSqlClient::Tuple] args the list of arguments
    # @yield 
    # @return [self]
    def execute(args=nil)
      if block_given? && args == nil
        @j_del.java_method(:execute, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) }))
        return self
      elsif args.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:execute, [Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(args.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling execute(#{args})"
    end
    #  Create a cursor with the provided <code>arguments</code>.
    # @param [::VertxSqlClient::Tuple] args the list of arguments
    # @return [::VertxSqlClient::Cursor] the query
    def cursor(args=nil)
      if !block_given? && args == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cursor, []).call(),::VertxSqlClient::Cursor)
      elsif args.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cursor, [Java::IoVertxSqlclient::Tuple.java_class]).call(args.j_del),::VertxSqlClient::Cursor)
      end
      raise ArgumentError, "Invalid arguments when calling cursor(#{args})"
    end
    #  Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
    #  with a <code>fetch</code> size to fetch the results.
    #  <p/>
    #  Note: this requires to be in a transaction, since cursors require it.
    # @param [Fixnum] fetch the cursor fetch size
    # @param [::VertxSqlClient::Tuple] args the prepared query arguments
    # @return [::VertxSqlClient::RowStream] the createStream
    def create_stream(fetch=nil,args=nil)
      if fetch.class == Fixnum && args.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createStream, [Java::int.java_class,Java::IoVertxSqlclient::Tuple.java_class]).call(fetch,args.j_del),::VertxSqlClient::RowStream,::VertxSqlClient::Row.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling create_stream(#{fetch},#{args})"
    end
    #  Execute a batch.
    # @param [Array<::VertxSqlClient::Tuple>] argsList the list of tuple for the batch
    # @yield 
    # @return [self]
    def batch(argsList=nil)
      if argsList.class == Array && block_given?
        @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(argsList.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling batch(#{argsList})"
    end
    #  Like {::VertxSqlClient::PreparedQuery#close} but notifies the <code>completionHandler</code> when it's closed.
    # @yield 
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
