require 'vertx-sql-client/sql_client'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/transaction'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.SqlConnection
module VertxSqlClient
  #  A connection to database server.
  class SqlConnection < ::VertxSqlClient::SqlClient
    # @private
    # @param j_del [::VertxSqlClient::SqlConnection] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::SqlConnection] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SqlConnection
    end
    def @@j_api_type.wrap(obj)
      SqlConnection.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::SqlConnection.java_class
    end
    #  Create a prepared query.
    # @param [String] sql the sql
    # @yield the handler notified with the prepared query asynchronously
    # @return [self]
    def prepare(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:prepare, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::PreparedQuery) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepare(#{sql})"
    end
    #  Set an handler called with connection errors.
    # @yield the handler
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    #  Set an handler called when the connection is closed.
    # @yield the handler
    # @return [self]
    def close_handler
      if block_given?
        @j_del.java_method(:closeHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling close_handler()"
    end
    #  Begin a transaction and returns a {::VertxSqlClient::Transaction} for controlling and tracking
    #  this transaction.
    #  <p/>
    #  When the connection is explicitely closed, any inflight transaction is rollbacked.
    # @return [::VertxSqlClient::Transaction] the transaction instance
    def begin
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:begin, []).call(),::VertxSqlClient::Transaction)
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    # @return [true,false] whether the connection uses SSL
    def ssl?
      if !block_given?
        return @j_del.java_method(:isSSL, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling ssl?()"
    end
    #  Close the current connection after all the pending commands have been processed.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    # @param [String] sql 
    # @param [::VertxSqlClient::Tuple] arguments 
    # @yield 
    # @return [self]
    def prepared_query(sql=nil,arguments=nil)
      if sql.class == String && block_given? && arguments == nil
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) }))
        return self
      elsif sql.class == String && arguments.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::Tuple.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,arguments.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql},#{arguments})"
    end
    # @param [String] sql 
    # @yield 
    # @return [self]
    def query(sql=nil)
      if sql.class == String && block_given?
        @j_del.java_method(:query, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    # @param [String] sql 
    # @param [Array<::VertxSqlClient::Tuple>] batch 
    # @yield 
    # @return [self]
    def prepared_batch(sql=nil,batch=nil)
      if sql.class == String && batch.class == Array && block_given?
        @j_del.java_method(:preparedBatch, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(sql,batch.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling prepared_batch(#{sql},#{batch})"
    end
  end
end
