require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.MultiTenantHandler
module VertxWeb
  #  A handler which selectively executes another handler if a precondition is met.
  # 
  #  There are cases where applications are build as multi tenant, in this cases one of the
  #  common tasks is to configure different authentication mechanisms for each tenant.
  # 
  #  This handler will allow registering any other handler and will only execute it if
  #  the precondition is met. There are 2 way of defining a precondition:
  # 
  #  <ul>
  #      <li>A http header value for example <pre>X-Tenant</pre></li>
  #      <li>A custom extractor function that can return a String from the context</li>
  #  </ul>
  # 
  #  Requests that pass the validation will contain a new key in the routing context with
  #  the tenant id, for the case of being a default handler the value if this key will be "default".
  class MultiTenantHandler
    # @private
    # @param j_del [::VertxWeb::MultiTenantHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWeb::MultiTenantHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MultiTenantHandler
    end
    def @@j_api_type.wrap(obj)
      MultiTenantHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandler::MultiTenantHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Create a MultiTenant handler using a custom tenant extraction function.
    # @overload create(header)
    #   @param [String] header the header to lookup (e.g.: "X-Tenant")
    # @overload create(tenantExtractor)
    #   @yield the function that extracts the tenant id from the request
    # @overload create(tenantExtractor,contextKey)
    #   @param [Proc] tenantExtractor the function that extracts the tenant id from the request
    #   @param [String] contextKey the custom key to store the tenant id in the context
    # @return [::VertxWeb::MultiTenantHandler] the new handler.
    def self.create(param_1=nil,param_2=nil)
      if param_1.class == String && !block_given? && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MultiTenantHandler.java_method(:create, [Java::java.lang.String.java_class]).call(param_1),::VertxWeb::MultiTenantHandler)
      elsif block_given? && param_1 == nil && param_2 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MultiTenantHandler.java_method(:create, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) })),::VertxWeb::MultiTenantHandler)
      elsif param_1.class == Proc && param_2.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtWebHandler::MultiTenantHandler.java_method(:create, [Java::JavaUtilFunction::Function.java_class,Java::java.lang.String.java_class]).call((Proc.new { |event| param_1.call(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }),param_2),::VertxWeb::MultiTenantHandler)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1},#{param_2})"
    end
    #  Add a handler for a given tenant to this handler.
    # 
    #  Both tenant and handler cannot be null.
    # @param [String] tenant the tenant id
    # @yield the handler to register.
    # @return [self]
    def add_tenant_handler(tenant=nil)
      if tenant.class == String && block_given?
        @j_del.java_method(:addTenantHandler, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(tenant,(Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_tenant_handler(#{tenant})"
    end
    #  Remove a handler for a given tenant from this handler.
    # 
    #  Tenant cannot be null.
    # @param [String] tenant the tenant id
    # @return [self]
    def remove_tenant(tenant=nil)
      if tenant.class == String && !block_given?
        @j_del.java_method(:removeTenant, [Java::java.lang.String.java_class]).call(tenant)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove_tenant(#{tenant})"
    end
    #  Add a default handler for the case when no tenant was matched.
    # 
    #  The handler cannot be null.
    # @yield the handler to register.
    # @return [self]
    def add_default_handler
      if block_given?
        @j_del.java_method(:addDefaultHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_default_handler()"
    end
    #  The default key used to identify a tenant in the context data.
    def self.TENANT
      Java::IoVertxExtWebHandler::MultiTenantHandler.TENANT
    end
  end
end
