require 'vertx/buffer'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Tuple
module VertxSqlClient
  #  A general purpose tuple.
  class Tuple
    # @private
    # @param j_del [::VertxSqlClient::Tuple] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Tuple] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Tuple
    end
    def @@j_api_type.wrap(obj)
      Tuple.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Tuple.java_class
    end
    #  Create a tuple with the provided <code>elements</code> list.
    #  <p/>
    #  The <code>elements</code> list is not modified.
    # @param [Array<Object>] elements the list of elements
    # @return [::VertxSqlClient::Tuple] the tuple
    def self.tuple(elements=nil)
      if !block_given? && elements == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:tuple, []).call(),::VertxSqlClient::Tuple)
      elsif elements.class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:tuple, [Java::JavaUtil::List.java_class]).call(elements.map { |element| ::Vertx::Util::Utils.to_object(element) }),::VertxSqlClient::Tuple)
      end
      raise ArgumentError, "Invalid arguments when calling tuple(#{elements})"
    end
    #  Wrap the provided <code>list</code> with a tuple.
    #  <br/>
    #  The list is not copied and is used as store for tuple elements.
    # @param [Array<Object>] list 
    # @return [::VertxSqlClient::Tuple] the list wrapped as a tuple
    def self.wrap(list=nil)
      if list.class == Array && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:wrap, [Java::JavaUtil::List.java_class]).call(list.map { |element| ::Vertx::Util::Utils.to_object(element) }),::VertxSqlClient::Tuple)
      end
      raise ArgumentError, "Invalid arguments when calling wrap(#{list})"
    end
    #  Create a tuple of six elements.
    # @param [Object] elt1 the first value
    # @param [Object] elt2 the second valueg
    # @param [Object] elt3 the third value
    # @param [Object] elt4 the fourth value
    # @param [Object] elt5 the fifth value
    # @param [Object] elt6 the sixth value
    # @return [::VertxSqlClient::Tuple] the tuple
    def self.of(elt1=nil,elt2=nil,elt3=nil,elt4=nil,elt5=nil,elt6=nil)
      if ::Vertx::Util::unknown_type.accept?(elt1) && !block_given? && elt2 == nil && elt3 == nil && elt4 == nil && elt5 == nil && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1)),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && !block_given? && elt3 == nil && elt4 == nil && elt5 == nil && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2)),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && ::Vertx::Util::unknown_type.accept?(elt3) && !block_given? && elt4 == nil && elt5 == nil && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2),::Vertx::Util::Utils.to_object(elt3)),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && ::Vertx::Util::unknown_type.accept?(elt3) && ::Vertx::Util::unknown_type.accept?(elt4) && !block_given? && elt5 == nil && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2),::Vertx::Util::Utils.to_object(elt3),::Vertx::Util::Utils.to_object(elt4)),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && ::Vertx::Util::unknown_type.accept?(elt3) && ::Vertx::Util::unknown_type.accept?(elt4) && ::Vertx::Util::unknown_type.accept?(elt5) && !block_given? && elt6 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2),::Vertx::Util::Utils.to_object(elt3),::Vertx::Util::Utils.to_object(elt4),::Vertx::Util::Utils.to_object(elt5)),::VertxSqlClient::Tuple)
      elsif ::Vertx::Util::unknown_type.accept?(elt1) && ::Vertx::Util::unknown_type.accept?(elt2) && ::Vertx::Util::unknown_type.accept?(elt3) && ::Vertx::Util::unknown_type.accept?(elt4) && ::Vertx::Util::unknown_type.accept?(elt5) && ::Vertx::Util::unknown_type.accept?(elt6) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxSqlclient::Tuple.java_method(:of, [Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class,Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(elt1),::Vertx::Util::Utils.to_object(elt2),::Vertx::Util::Utils.to_object(elt3),::Vertx::Util::Utils.to_object(elt4),::Vertx::Util::Utils.to_object(elt5),::Vertx::Util::Utils.to_object(elt6)),::VertxSqlClient::Tuple)
      end
      raise ArgumentError, "Invalid arguments when calling of(#{elt1},#{elt2},#{elt3},#{elt4},#{elt5},#{elt6})"
    end
    #  Get an object value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Object] the value or <code>null</code>
    def get_value(pos=nil)
      if pos.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getValue, [Java::int.java_class]).call(pos))
      end
      raise ArgumentError, "Invalid arguments when calling get_value(#{pos})"
    end
    #  Get a boolean value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [true,false] the value or <code>null</code>
    def get_boolean?(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getBoolean, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_boolean?(#{pos})"
    end
    #  Get a short value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_short(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getShort, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_short(#{pos})"
    end
    #  Get an integer value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_integer(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getInteger, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_integer(#{pos})"
    end
    #  Get a long value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Fixnum] the value or <code>null</code>
    def get_long(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getLong, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_long(#{pos})"
    end
    #  Get a float value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Float] the value or <code>null</code>
    def get_float(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getFloat, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_float(#{pos})"
    end
    #  Get a double value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [Float] the value or <code>null</code>
    def get_double(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getDouble, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_double(#{pos})"
    end
    #  Get a string value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [String] the value or <code>null</code>
    def get_string(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getString, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_string(#{pos})"
    end
    #  Get a buffer value at <code>pos</code>.
    # @param [Fixnum] pos the position
    # @return [::Vertx::Buffer] the value or <code>null</code>
    def get_buffer(pos=nil)
      if pos.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::int.java_class]).call(pos),::Vertx::Buffer)
      end
      raise ArgumentError, "Invalid arguments when calling get_buffer(#{pos})"
    end
    #  Add an object value at the end of the tuple.
    # @param [Object] value the value
    # @return [self]
    def add_value(value=nil)
      if ::Vertx::Util::unknown_type.accept?(value) && !block_given?
        @j_del.java_method(:addValue, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_value(#{value})"
    end
    #  Add a boolean value at the end of the tuple.
    # @param [true,false] value the value
    # @return [self]
    def add_boolean(value=nil)
      if (value.class == TrueClass || value.class == FalseClass) && !block_given?
        @j_del.java_method(:addBoolean, [Java::JavaLang::Boolean.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_boolean(#{value})"
    end
    #  Add a short value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_short(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addShort, [Java::JavaLang::Short.java_class]).call(::Vertx::Util::Utils.to_short(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_short(#{value})"
    end
    #  Add an integer value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_integer(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addInteger, [Java::JavaLang::Integer.java_class]).call(::Vertx::Util::Utils.to_integer(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_integer(#{value})"
    end
    #  Add a long value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_long(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addLong, [Java::JavaLang::Long.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_long(#{value})"
    end
    #  Add a float value at the end of the tuple.
    # @param [Float] value the value
    # @return [self]
    def add_float(value=nil)
      if value.class == Float && !block_given?
        @j_del.java_method(:addFloat, [Java::JavaLang::Float.java_class]).call(::Vertx::Util::Utils.to_float(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_float(#{value})"
    end
    #  Add a double value at the end of the tuple.
    # @param [Float] value the value
    # @return [self]
    def add_double(value=nil)
      if value.class == Float && !block_given?
        @j_del.java_method(:addDouble, [Java::JavaLang::Double.java_class]).call(::Vertx::Util::Utils.to_double(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_double(#{value})"
    end
    #  Add a string value at the end of the tuple.
    # @param [String] value the value
    # @return [self]
    def add_string(value=nil)
      if value.class == String && !block_given?
        @j_del.java_method(:addString, [Java::java.lang.String.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_string(#{value})"
    end
    #  Add a buffer value at the end of the tuple.
    # @param [::Vertx::Buffer] value the value
    # @return [self]
    def add_buffer(value=nil)
      if value.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(value.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_buffer(#{value})"
    end
    # @param [Nil] type 
    # @param [Fixnum] pos 
    # @return [Object]
    def get(type=nil,pos=nil)
      if type.class == Class && pos.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.v_type_of(type).wrap(@j_del.java_method(:get, [Java::JavaLang::Class.java_class,Java::int.java_class]).call(::Vertx::Util::Utils.j_class_of(type),pos))
      end
      raise ArgumentError, "Invalid arguments when calling get(#{type},#{pos})"
    end
    # @return [Fixnum] the tuple size
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size()"
    end
    # @return [void]
    def clear
      if !block_given?
        return @j_del.java_method(:clear, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling clear()"
    end
    #  The JSON null literal value.
    #  <br/>
    #  It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
    #  used when the database supports JSON types.
    def self.JSON_NULL
      ::Vertx::Util::Utils.from_object(Java::IoVertxSqlclient::Tuple.JSON_NULL)
    end
  end
end
