require 'vertx-auth-oauth2/o_auth2_rbac'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.rbac.KeycloakRBAC
module VertxAuthOauth2
  #  Implementation of the Keycloak RBAC handler.
  class KeycloakRBAC
    # @private
    # @param j_del [::VertxAuthOauth2::KeycloakRBAC] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::KeycloakRBAC] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == KeycloakRBAC
    end
    def @@j_api_type.wrap(obj)
      KeycloakRBAC.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2Rbac::KeycloakRBAC.java_class
    end
    #  Factory method to create a RBAC handler for tokens adhering to the Keycloak token format.
    # @param [Hash] options 
    # @return [::VertxAuthOauth2::OAuth2RBAC] a RBAC validator
    def self.create(options=nil)
      if options.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2Rbac::KeycloakRBAC.java_method(:create, [Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.java_class]).call(Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.new(::Vertx::Util::Utils.to_json_object(options))),::VertxAuthOauth2::OAuth2RBAC)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{options})"
    end
  end
end
