require 'vertx/async_file'
require 'vertx/pipe'
require 'vertx/buffer'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.http.HttpServerFileUpload
module Vertx
  #  Represents an file upload from an HTML FORM.
  class HttpServerFileUpload
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::Vertx::HttpServerFileUpload] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::Vertx::HttpServerFileUpload] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == HttpServerFileUpload
    end
    def @@j_api_type.wrap(obj)
      HttpServerFileUpload.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxCoreHttp::HttpServerFileUpload.java_class
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::Vertx::Buffer.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class]).call(dst.j_del)
      elsif dst.class.method_defined?(:j_del) && block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Buffer)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    #  Stream the content of this upload to the given file on storage.
    # @param [String] filename the name of the file
    # @return [self]
    def stream_to_file_system(filename=nil)
      if filename.class == String && !block_given?
        @j_del.java_method(:streamToFileSystem, [Java::java.lang.String.java_class]).call(filename)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling stream_to_file_system(#{filename})"
    end
    # @return [String] the filename which was used when upload the file.
    def filename
      if !block_given?
        return @j_del.java_method(:filename, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling filename()"
    end
    # @return [String] the name of the attribute
    def name
      if !block_given?
        return @j_del.java_method(:name, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling name()"
    end
    # @return [String] the content type for the upload
    def content_type
      if !block_given?
        return @j_del.java_method(:contentType, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling content_type()"
    end
    # @return [String] the contentTransferEncoding for the upload
    def content_transfer_encoding
      if !block_given?
        return @j_del.java_method(:contentTransferEncoding, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling content_transfer_encoding()"
    end
    # @return [String] the charset for the upload
    def charset
      if !block_given?
        return @j_del.java_method(:charset, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling charset()"
    end
    #  The size of the upload may not be available until it is all read.
    #  Check {::Vertx::HttpServerFileUpload#is_size_available} to determine this
    # @return [Fixnum] the size of the upload (in bytes)
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size()"
    end
    # @return [true,false] <code>true</code> if the size of the upload can be retrieved via {::Vertx::HttpServerFileUpload#size}.
    def size_available?
      if !block_given?
        return @j_del.java_method(:isSizeAvailable, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size_available?()"
    end
    # @return [::Vertx::AsyncFile] the async uploaded file when {::Vertx::HttpServerFileUpload#stream_to_file_system} has been used
    def file
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:file, []).call(),::Vertx::AsyncFile)
      end
      raise ArgumentError, "Invalid arguments when calling file()"
    end
  end
end
