require 'vertx-web/routing_context'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.handler.graphql.GraphQLHandler
module VertxWebGraphql
  #  A {::VertxWeb::Route} handler for GraphQL requests.
  class GraphQLHandler
    # @private
    # @param j_del [::VertxWebGraphql::GraphQLHandler] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebGraphql::GraphQLHandler] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == GraphQLHandler
    end
    def @@j_api_type.wrap(obj)
      GraphQLHandler.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebHandlerGraphql::GraphQLHandler.java_class
    end
    #  Something has happened, so handle it.
    # @param [::VertxWeb::RoutingContext] event the event to handle
    # @return [void]
    def handle(event=nil)
      if event.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:handle, [Java::IoVertxExtWeb::RoutingContext.java_class]).call(event.j_del)
      end
      raise ArgumentError, "Invalid arguments when calling handle(#{event})"
    end
    #  Customize the query context object.
    #  The provided <code>factory</code> method will be invoked for each incoming GraphQL request.
    # @yield 
    # @return [self]
    def query_context(factory=nil)
      if block_given? && factory == nil
        @j_del.java_method(:queryContext, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(::Vertx::Util::Utils.safe_create(event,::VertxWeb::RoutingContext))) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling query_context(#{factory})"
    end
  end
end
