require 'vertx-sql-client/row_stream'
require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/cursor'
require 'vertx-sql-client/prepared_query'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.PreparedStatement
module VertxSqlClient
  #  A prepared statement, the statement is pre-compiled and it's more efficient to execute the statement for multiple times.
  #  In addition, this kind of statement provides protection against SQL injection attacks.
  # 
  #  <p>From a prepared statement you can
  # 
  #  <ul>
  #    <li>use {::VertxSqlClient::PreparedStatement#query} to create and execute a {::VertxSqlClient::PreparedQuery}</li>
  #    <li>use {::VertxSqlClient::PreparedStatement#cursor} to create a {::VertxSqlClient::Cursor}</li>
  #    <li>use {::VertxSqlClient::PreparedStatement#create_stream} to create a {::VertxSqlClient::RowStream}</li>
  #  </ul>
  class PreparedStatement
    # @private
    # @param j_del [::VertxSqlClient::PreparedStatement] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::PreparedStatement] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == PreparedStatement
    end
    def @@j_api_type.wrap(obj)
      PreparedStatement.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::PreparedStatement.java_class
    end
    #  Create a prepared query for this statement.
    # @return [::VertxSqlClient::PreparedQuery] the prepared query
    def query
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:query, []).call(),::VertxSqlClient::PreparedQuery,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling query()"
    end
    #  Create a cursor with the provided <code>arguments</code>.
    # @param [::VertxSqlClient::Tuple] args the list of arguments
    # @return [::VertxSqlClient::Cursor] the query
    def cursor(args=nil)
      if !block_given? && args == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cursor, []).call(),::VertxSqlClient::Cursor)
      elsif args.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:cursor, [Java::IoVertxSqlclient::Tuple.java_class]).call(args.j_del),::VertxSqlClient::Cursor)
      end
      raise ArgumentError, "Invalid arguments when calling cursor(#{args})"
    end
    #  Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
    #  with a <code>fetch</code> size to fetch the results.
    #  <p/>
    #  Note: this requires to be in a transaction, since cursors require it.
    # @param [Fixnum] fetch the cursor fetch size
    # @param [::VertxSqlClient::Tuple] args the prepared query arguments
    # @return [::VertxSqlClient::RowStream] the createStream
    def create_stream(fetch=nil,args=nil)
      if fetch.class == Fixnum && args.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:createStream, [Java::int.java_class,Java::IoVertxSqlclient::Tuple.java_class]).call(fetch,args.j_del),::VertxSqlClient::RowStream,::VertxSqlClient::Row.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling create_stream(#{fetch},#{args})"
    end
    #  Like {::VertxSqlClient::PreparedStatement#close} but notifies the <code>completionHandler</code> when it's closed.
    # @yield 
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
