require 'vertx-sql-client/query'
require 'vertx-sql-client/row'
require 'vertx/vertx'
require 'vertx-sql-client/pool'
require 'vertx-sql-client/row_set'
require 'vertx-sql-client/prepared_query'
require 'vertx/util/utils.rb'
# Generated from io.vertx.db2client.DB2Pool
module VertxDb2Client
  #  A pool of DB2 connections.
  class DB2Pool < ::VertxSqlClient::Pool
    # @private
    # @param j_del [::VertxDb2Client::DB2Pool] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxDb2Client::DB2Pool] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == DB2Pool
    end
    def @@j_api_type.wrap(obj)
      DB2Pool.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxDb2client::DB2Pool.java_class
    end
    #  Get a connection from the pool.
    # @yield the handler that will get the connection result
    # @return [void]
    def get_connection
      if block_given?
        return @j_del.java_method(:getConnection, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::SqlConnection) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling get_connection()"
    end
    #  
    # 
    #  A connection is borrowed from the connection pool when the query is executed and then immediately returned
    #  to the pool after it completes.
    # @param [String] sql 
    # @return [::VertxSqlClient::Query]
    def query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:query, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::Query,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling query(#{sql})"
    end
    #  
    # 
    #  A connection is borrowed from the connection pool when the query is executed and then immediately returned
    #  to the pool after it completes.
    # @param [String] sql 
    # @return [::VertxSqlClient::PreparedQuery]
    def prepared_query(sql=nil)
      if sql.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:preparedQuery, [Java::java.lang.String.java_class]).call(sql),::VertxSqlClient::PreparedQuery,::VertxSqlClient::RowSet.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling prepared_query(#{sql})"
    end
    #  Borrow a connection from the pool and begin a transaction, the underlying connection will be returned
    #  to the pool when the transaction ends.
    # @yield 
    # @return [void]
    def begin
      if block_given?
        return @j_del.java_method(:begin, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::Transaction) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling begin()"
    end
    #  Close the pool and release the associated resources.
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    #  Like {::VertxDb2Client::DB2Pool#pool} with a specific
    #   instance.
    # @overload pool(connectionUri)
    #   @param [String] connectionUri 
    # @overload pool(connectionUri,poolOptions)
    #   @param [String] connectionUri 
    #   @param [Hash] poolOptions 
    # @overload pool(vertx,connectionUri)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    # @overload pool(connectOptions,poolOptions)
    #   @param [Hash] connectOptions the options for the connection
    #   @param [Hash] poolOptions the options for creating the pool
    # @overload pool(vertx,connectionUri,poolOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] connectionUri 
    #   @param [Hash] poolOptions 
    # @overload pool(vertx,connectOptions,poolOptions)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash] connectOptions 
    #   @param [Hash] poolOptions 
    # @return [::VertxDb2Client::DB2Pool]
    def self.pool(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class == String && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxDb2client::DB2Pool.java_method(:pool, [Java::java.lang.String.java_class]).call(param_1),::VertxDb2Client::DB2Pool)
      elsif param_1.class == String && param_2.class == Hash && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxDb2client::DB2Pool.java_method(:pool, [Java::java.lang.String.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(param_1,Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxDb2Client::DB2Pool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxDb2client::DB2Pool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(param_1.j_del,param_2),::VertxDb2Client::DB2Pool)
      elsif param_1.class == Hash && param_2.class == Hash && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxDb2client::DB2Pool.java_method(:pool, [Java::IoVertxDb2client::DB2ConnectOptions.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(Java::IoVertxDb2client::DB2ConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_1)),Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxDb2Client::DB2Pool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == String && param_3.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxDb2client::DB2Pool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(param_1.j_del,param_2,Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_3))),::VertxDb2Client::DB2Pool)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && param_3.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxDb2client::DB2Pool.java_method(:pool, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxDb2client::DB2ConnectOptions.java_class,Java::IoVertxSqlclient::PoolOptions.java_class]).call(param_1.j_del,Java::IoVertxDb2client::DB2ConnectOptions.new(::Vertx::Util::Utils.to_json_object(param_2)),Java::IoVertxSqlclient::PoolOptions.new(::Vertx::Util::Utils.to_json_object(param_3))),::VertxDb2Client::DB2Pool)
      end
      raise ArgumentError, "Invalid arguments when calling pool(#{param_1},#{param_2},#{param_3})"
    end
  end
end
