require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.Command
module VertxRedis
  #  <b>Auto generated</b> API Commands to interact with REDIS.
  class Command
    # @private
    # @param j_del [::VertxRedis::Command] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::Command] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Command
    end
    def @@j_api_type.wrap(obj)
      Command.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::Command.java_class
    end
    #  Creates a Redis Command from METADATA. The metadata comes from the REDIS command "COMMAND"
    #  https://redis.io/commands/command
    # 
    #  Each top-level result contains six nested results. Each nested result is:
    # 
    #      command name
    #      command arity specification
    #      nested Array reply of command flags
    #      position of first key in argument list
    #      position of last key in argument list
    #      step count for locating repeating keys
    # @param [String] command command name
    # @param [Fixnum] arity arity
    # @param [Fixnum] firstKey position of the first key
    # @param [Fixnum] lastKey position of the last key
    # @param [Fixnum] interval step count for locating repeating keys
    # @param [true,false] readOnly readOnly flag extracted from the nested Array reply of command flags
    # @param [true,false] movable movable flag extracted from the nested Array reply of command flags
    # @return [::VertxRedis::Command] a command instance
    def self.create(command=nil,arity=nil,firstKey=nil,lastKey=nil,interval=nil,readOnly=nil,movable=nil)
      if command.class == String && arity.class == Fixnum && firstKey.class == Fixnum && lastKey.class == Fixnum && interval.class == Fixnum && (readOnly.class == TrueClass || readOnly.class == FalseClass) && (movable.class == TrueClass || movable.class == FalseClass) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.java_method(:create, [Java::java.lang.String.java_class,Java::int.java_class,Java::int.java_class,Java::int.java_class,Java::int.java_class,Java::boolean.java_class,Java::boolean.java_class]).call(command,arity,firstKey,lastKey,interval,readOnly,movable),::VertxRedis::Command)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{command},#{arity},#{firstKey},#{lastKey},#{interval},#{readOnly},#{movable})"
    end
    # @return [Fixnum]
    def get_arity
      if !block_given?
        return @j_del.java_method(:getArity, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_arity()"
    end
    # @return [true,false]
    def multi_key?
      if !block_given?
        return @j_del.java_method(:isMultiKey, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling multi_key?()"
    end
    # @return [Fixnum]
    def get_first_key
      if !block_given?
        return @j_del.java_method(:getFirstKey, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_first_key()"
    end
    # @return [Fixnum]
    def get_last_key
      if !block_given?
        return @j_del.java_method(:getLastKey, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_last_key()"
    end
    # @return [Fixnum]
    def get_interval
      if !block_given?
        return @j_del.java_method(:getInterval, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_interval()"
    end
    # @return [true,false]
    def keyless?
      if !block_given?
        return @j_del.java_method(:isKeyless, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling keyless?()"
    end
    # @return [true,false]
    def read_only?
      if !block_given?
        return @j_del.java_method(:isReadOnly, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling read_only?()"
    end
    # @return [true,false]
    def movable?
      if !block_given?
        return @j_del.java_method(:isMovable, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling movable?()"
    end
    # @return [true,false]
    def void?
      if !block_given?
        return @j_del.java_method(:isVoid, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling void?()"
    end
    def self.APPEND
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.APPEND,::VertxRedis::Command)
    end
    def self.ASKING
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ASKING,::VertxRedis::Command)
    end
    def self.AUTH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.AUTH,::VertxRedis::Command)
    end
    def self.BGREWRITEAOF
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BGREWRITEAOF,::VertxRedis::Command)
    end
    def self.BGSAVE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BGSAVE,::VertxRedis::Command)
    end
    def self.BITCOUNT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BITCOUNT,::VertxRedis::Command)
    end
    def self.BITFIELD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BITFIELD,::VertxRedis::Command)
    end
    def self.BITOP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BITOP,::VertxRedis::Command)
    end
    def self.BITPOS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BITPOS,::VertxRedis::Command)
    end
    def self.BLPOP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BLPOP,::VertxRedis::Command)
    end
    def self.BRPOP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BRPOP,::VertxRedis::Command)
    end
    def self.BRPOPLPUSH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BRPOPLPUSH,::VertxRedis::Command)
    end
    def self.BZPOPMAX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BZPOPMAX,::VertxRedis::Command)
    end
    def self.BZPOPMIN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.BZPOPMIN,::VertxRedis::Command)
    end
    def self.CLIENT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.CLIENT,::VertxRedis::Command)
    end
    def self.CLUSTER
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.CLUSTER,::VertxRedis::Command)
    end
    def self.COMMAND
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.COMMAND,::VertxRedis::Command)
    end
    def self.CONFIG
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.CONFIG,::VertxRedis::Command)
    end
    def self.DBSIZE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.DBSIZE,::VertxRedis::Command)
    end
    def self.DEBUG
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.DEBUG,::VertxRedis::Command)
    end
    def self.DECR
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.DECR,::VertxRedis::Command)
    end
    def self.DECRBY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.DECRBY,::VertxRedis::Command)
    end
    def self.DEL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.DEL,::VertxRedis::Command)
    end
    def self.DISCARD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.DISCARD,::VertxRedis::Command)
    end
    def self.DUMP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.DUMP,::VertxRedis::Command)
    end
    def self.ECHO
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ECHO,::VertxRedis::Command)
    end
    def self.EVAL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.EVAL,::VertxRedis::Command)
    end
    def self.EVALSHA
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.EVALSHA,::VertxRedis::Command)
    end
    def self.EXEC
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.EXEC,::VertxRedis::Command)
    end
    def self.EXISTS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.EXISTS,::VertxRedis::Command)
    end
    def self.EXPIRE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.EXPIRE,::VertxRedis::Command)
    end
    def self.EXPIREAT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.EXPIREAT,::VertxRedis::Command)
    end
    def self.FLUSHALL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.FLUSHALL,::VertxRedis::Command)
    end
    def self.FLUSHDB
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.FLUSHDB,::VertxRedis::Command)
    end
    def self.GEOADD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GEOADD,::VertxRedis::Command)
    end
    def self.GEODIST
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GEODIST,::VertxRedis::Command)
    end
    def self.GEOHASH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GEOHASH,::VertxRedis::Command)
    end
    def self.GEOPOS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GEOPOS,::VertxRedis::Command)
    end
    def self.GEORADIUS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GEORADIUS,::VertxRedis::Command)
    end
    def self.GEORADIUS_RO
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GEORADIUS_RO,::VertxRedis::Command)
    end
    def self.GEORADIUSBYMEMBER
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GEORADIUSBYMEMBER,::VertxRedis::Command)
    end
    def self.GEORADIUSBYMEMBER_RO
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GEORADIUSBYMEMBER_RO,::VertxRedis::Command)
    end
    def self.GET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GET,::VertxRedis::Command)
    end
    def self.GETBIT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GETBIT,::VertxRedis::Command)
    end
    def self.GETRANGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GETRANGE,::VertxRedis::Command)
    end
    def self.GETSET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.GETSET,::VertxRedis::Command)
    end
    def self.HDEL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HDEL,::VertxRedis::Command)
    end
    def self.HEXISTS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HEXISTS,::VertxRedis::Command)
    end
    def self.HGET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HGET,::VertxRedis::Command)
    end
    def self.HGETALL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HGETALL,::VertxRedis::Command)
    end
    def self.HINCRBY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HINCRBY,::VertxRedis::Command)
    end
    def self.HINCRBYFLOAT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HINCRBYFLOAT,::VertxRedis::Command)
    end
    def self.HKEYS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HKEYS,::VertxRedis::Command)
    end
    def self.HLEN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HLEN,::VertxRedis::Command)
    end
    def self.HMGET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HMGET,::VertxRedis::Command)
    end
    def self.HMSET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HMSET,::VertxRedis::Command)
    end
    def self.HOST
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HOST,::VertxRedis::Command)
    end
    def self.HSCAN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HSCAN,::VertxRedis::Command)
    end
    def self.HSET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HSET,::VertxRedis::Command)
    end
    def self.HSETNX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HSETNX,::VertxRedis::Command)
    end
    def self.HSTRLEN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HSTRLEN,::VertxRedis::Command)
    end
    def self.HVALS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.HVALS,::VertxRedis::Command)
    end
    def self.INCR
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.INCR,::VertxRedis::Command)
    end
    def self.INCRBY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.INCRBY,::VertxRedis::Command)
    end
    def self.INCRBYFLOAT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.INCRBYFLOAT,::VertxRedis::Command)
    end
    def self.INFO
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.INFO,::VertxRedis::Command)
    end
    def self.KEYS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.KEYS,::VertxRedis::Command)
    end
    def self.LASTSAVE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LASTSAVE,::VertxRedis::Command)
    end
    def self.LATENCY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LATENCY,::VertxRedis::Command)
    end
    def self.LINDEX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LINDEX,::VertxRedis::Command)
    end
    def self.LINSERT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LINSERT,::VertxRedis::Command)
    end
    def self.LLEN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LLEN,::VertxRedis::Command)
    end
    def self.LOLWUT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LOLWUT,::VertxRedis::Command)
    end
    def self.LPOP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LPOP,::VertxRedis::Command)
    end
    def self.LPUSH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LPUSH,::VertxRedis::Command)
    end
    def self.LPUSHX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LPUSHX,::VertxRedis::Command)
    end
    def self.LRANGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LRANGE,::VertxRedis::Command)
    end
    def self.LREM
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LREM,::VertxRedis::Command)
    end
    def self.LSET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LSET,::VertxRedis::Command)
    end
    def self.LTRIM
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.LTRIM,::VertxRedis::Command)
    end
    def self.MEMORY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MEMORY,::VertxRedis::Command)
    end
    def self.MGET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MGET,::VertxRedis::Command)
    end
    def self.MIGRATE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MIGRATE,::VertxRedis::Command)
    end
    def self.MODULE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MODULE,::VertxRedis::Command)
    end
    def self.MONITOR
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MONITOR,::VertxRedis::Command)
    end
    def self.MOVE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MOVE,::VertxRedis::Command)
    end
    def self.MSET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MSET,::VertxRedis::Command)
    end
    def self.MSETNX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MSETNX,::VertxRedis::Command)
    end
    def self.MULTI
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.MULTI,::VertxRedis::Command)
    end
    def self.OBJECT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.OBJECT,::VertxRedis::Command)
    end
    def self.PERSIST
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PERSIST,::VertxRedis::Command)
    end
    def self.PEXPIRE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PEXPIRE,::VertxRedis::Command)
    end
    def self.PEXPIREAT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PEXPIREAT,::VertxRedis::Command)
    end
    def self.PFADD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PFADD,::VertxRedis::Command)
    end
    def self.PFCOUNT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PFCOUNT,::VertxRedis::Command)
    end
    def self.PFDEBUG
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PFDEBUG,::VertxRedis::Command)
    end
    def self.PFMERGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PFMERGE,::VertxRedis::Command)
    end
    def self.PFSELFTEST
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PFSELFTEST,::VertxRedis::Command)
    end
    def self.PING
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PING,::VertxRedis::Command)
    end
    def self.POST
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.POST,::VertxRedis::Command)
    end
    def self.PSETEX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PSETEX,::VertxRedis::Command)
    end
    def self.PSUBSCRIBE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PSUBSCRIBE,::VertxRedis::Command)
    end
    def self.PSYNC
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PSYNC,::VertxRedis::Command)
    end
    def self.PTTL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PTTL,::VertxRedis::Command)
    end
    def self.PUBLISH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PUBLISH,::VertxRedis::Command)
    end
    def self.PUBSUB
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PUBSUB,::VertxRedis::Command)
    end
    def self.PUNSUBSCRIBE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.PUNSUBSCRIBE,::VertxRedis::Command)
    end
    def self.RANDOMKEY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RANDOMKEY,::VertxRedis::Command)
    end
    def self.READONLY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.READONLY,::VertxRedis::Command)
    end
    def self.READWRITE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.READWRITE,::VertxRedis::Command)
    end
    def self.RENAME
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RENAME,::VertxRedis::Command)
    end
    def self.RENAMENX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RENAMENX,::VertxRedis::Command)
    end
    def self.REPLCONF
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.REPLCONF,::VertxRedis::Command)
    end
    def self.REPLICAOF
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.REPLICAOF,::VertxRedis::Command)
    end
    def self.RESTORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RESTORE,::VertxRedis::Command)
    end
    def self.RESTORE_ASKING
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RESTORE_ASKING,::VertxRedis::Command)
    end
    def self.ROLE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ROLE,::VertxRedis::Command)
    end
    def self.RPOP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RPOP,::VertxRedis::Command)
    end
    def self.RPOPLPUSH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RPOPLPUSH,::VertxRedis::Command)
    end
    def self.RPUSH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RPUSH,::VertxRedis::Command)
    end
    def self.RPUSHX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.RPUSHX,::VertxRedis::Command)
    end
    def self.SADD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SADD,::VertxRedis::Command)
    end
    def self.SAVE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SAVE,::VertxRedis::Command)
    end
    def self.SCAN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SCAN,::VertxRedis::Command)
    end
    def self.SCARD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SCARD,::VertxRedis::Command)
    end
    def self.SCRIPT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SCRIPT,::VertxRedis::Command)
    end
    def self.SDIFF
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SDIFF,::VertxRedis::Command)
    end
    def self.SDIFFSTORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SDIFFSTORE,::VertxRedis::Command)
    end
    def self.SELECT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SELECT,::VertxRedis::Command)
    end
    def self.SET
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SET,::VertxRedis::Command)
    end
    def self.SETBIT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SETBIT,::VertxRedis::Command)
    end
    def self.SETEX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SETEX,::VertxRedis::Command)
    end
    def self.SETNX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SETNX,::VertxRedis::Command)
    end
    def self.SETRANGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SETRANGE,::VertxRedis::Command)
    end
    def self.SHUTDOWN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SHUTDOWN,::VertxRedis::Command)
    end
    def self.SINTER
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SINTER,::VertxRedis::Command)
    end
    def self.SINTERSTORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SINTERSTORE,::VertxRedis::Command)
    end
    def self.SISMEMBER
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SISMEMBER,::VertxRedis::Command)
    end
    def self.SLAVEOF
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SLAVEOF,::VertxRedis::Command)
    end
    def self.SLOWLOG
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SLOWLOG,::VertxRedis::Command)
    end
    def self.SMEMBERS
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SMEMBERS,::VertxRedis::Command)
    end
    def self.SMOVE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SMOVE,::VertxRedis::Command)
    end
    def self.SORT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SORT,::VertxRedis::Command)
    end
    def self.SPOP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SPOP,::VertxRedis::Command)
    end
    def self.SRANDMEMBER
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SRANDMEMBER,::VertxRedis::Command)
    end
    def self.SREM
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SREM,::VertxRedis::Command)
    end
    def self.SSCAN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SSCAN,::VertxRedis::Command)
    end
    def self.STRLEN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.STRLEN,::VertxRedis::Command)
    end
    def self.SUBSCRIBE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SUBSCRIBE,::VertxRedis::Command)
    end
    def self.SUBSTR
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SUBSTR,::VertxRedis::Command)
    end
    def self.SUNION
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SUNION,::VertxRedis::Command)
    end
    def self.SUNIONSTORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SUNIONSTORE,::VertxRedis::Command)
    end
    def self.SWAPDB
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SWAPDB,::VertxRedis::Command)
    end
    def self.SYNC
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SYNC,::VertxRedis::Command)
    end
    def self.TIME
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.TIME,::VertxRedis::Command)
    end
    def self.TOUCH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.TOUCH,::VertxRedis::Command)
    end
    def self.TTL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.TTL,::VertxRedis::Command)
    end
    def self.TYPE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.TYPE,::VertxRedis::Command)
    end
    def self.UNLINK
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.UNLINK,::VertxRedis::Command)
    end
    def self.UNSUBSCRIBE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.UNSUBSCRIBE,::VertxRedis::Command)
    end
    def self.UNWATCH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.UNWATCH,::VertxRedis::Command)
    end
    def self.WAIT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.WAIT,::VertxRedis::Command)
    end
    def self.WATCH
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.WATCH,::VertxRedis::Command)
    end
    def self.XACK
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XACK,::VertxRedis::Command)
    end
    def self.XADD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XADD,::VertxRedis::Command)
    end
    def self.XCLAIM
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XCLAIM,::VertxRedis::Command)
    end
    def self.XDEL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XDEL,::VertxRedis::Command)
    end
    def self.XGROUP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XGROUP,::VertxRedis::Command)
    end
    def self.XINFO
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XINFO,::VertxRedis::Command)
    end
    def self.XLEN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XLEN,::VertxRedis::Command)
    end
    def self.XPENDING
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XPENDING,::VertxRedis::Command)
    end
    def self.XRANGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XRANGE,::VertxRedis::Command)
    end
    def self.XREAD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XREAD,::VertxRedis::Command)
    end
    def self.XREADGROUP
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XREADGROUP,::VertxRedis::Command)
    end
    def self.XREVRANGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XREVRANGE,::VertxRedis::Command)
    end
    def self.XSETID
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XSETID,::VertxRedis::Command)
    end
    def self.XTRIM
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.XTRIM,::VertxRedis::Command)
    end
    def self.ZADD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZADD,::VertxRedis::Command)
    end
    def self.ZCARD
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZCARD,::VertxRedis::Command)
    end
    def self.ZCOUNT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZCOUNT,::VertxRedis::Command)
    end
    def self.ZINCRBY
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZINCRBY,::VertxRedis::Command)
    end
    def self.ZINTERSTORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZINTERSTORE,::VertxRedis::Command)
    end
    def self.ZLEXCOUNT
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZLEXCOUNT,::VertxRedis::Command)
    end
    def self.ZPOPMAX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZPOPMAX,::VertxRedis::Command)
    end
    def self.ZPOPMIN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZPOPMIN,::VertxRedis::Command)
    end
    def self.ZRANGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZRANGE,::VertxRedis::Command)
    end
    def self.ZRANGEBYLEX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZRANGEBYLEX,::VertxRedis::Command)
    end
    def self.ZRANGEBYSCORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZRANGEBYSCORE,::VertxRedis::Command)
    end
    def self.ZRANK
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZRANK,::VertxRedis::Command)
    end
    def self.ZREM
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZREM,::VertxRedis::Command)
    end
    def self.ZREMRANGEBYLEX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZREMRANGEBYLEX,::VertxRedis::Command)
    end
    def self.ZREMRANGEBYRANK
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZREMRANGEBYRANK,::VertxRedis::Command)
    end
    def self.ZREMRANGEBYSCORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZREMRANGEBYSCORE,::VertxRedis::Command)
    end
    def self.ZREVRANGE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZREVRANGE,::VertxRedis::Command)
    end
    def self.ZREVRANGEBYLEX
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZREVRANGEBYLEX,::VertxRedis::Command)
    end
    def self.ZREVRANGEBYSCORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZREVRANGEBYSCORE,::VertxRedis::Command)
    end
    def self.ZREVRANK
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZREVRANK,::VertxRedis::Command)
    end
    def self.ZSCAN
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZSCAN,::VertxRedis::Command)
    end
    def self.ZSCORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZSCORE,::VertxRedis::Command)
    end
    def self.ZUNIONSTORE
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.ZUNIONSTORE,::VertxRedis::Command)
    end
    def self.SENTINEL
      ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Command.SENTINEL,::VertxRedis::Command)
    end
  end
end
