require 'vertx-sql-client/row'
require 'vertx-sql-client/row_set'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Cursor
module VertxSqlClient
  #  A cursor that reads progressively rows from the database, it is useful for reading very large result sets.
  class Cursor
    # @private
    # @param j_del [::VertxSqlClient::Cursor] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Cursor] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Cursor
    end
    def @@j_api_type.wrap(obj)
      Cursor.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Cursor.java_class
    end
    #  Read rows from the cursor, the result is provided asynchronously to the <code>handler</code>.
    # @param [Fixnum] count the amount of rows to read
    # @yield the handler for the result
    # @return [void]
    def read(count=nil)
      if count.class == Fixnum && block_given?
        return @j_del.java_method(:read, [Java::int.java_class,Java::IoVertxCore::Handler.java_class]).call(count,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxSqlClient::RowSet,::VertxSqlClient::Row.j_api_type) : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling read(#{count})"
    end
    #  Returns <code>true</code> when the cursor has results in progress and the {::VertxSqlClient::Cursor#read} should be called to retrieve
    #  them.
    # @return [true,false] whether the cursor has more results,
    def has_more?
      if !block_given?
        return @j_del.java_method(:hasMore, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling has_more?()"
    end
    #  Like {::VertxSqlClient::Cursor#close} but with a <code>completionHandler</code> called when the cursor has been released.
    # @yield 
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    # @return [true,false] whether the cursor is closed
    def closed?
      if !block_given?
        return @j_del.java_method(:isClosed, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling closed?()"
    end
  end
end
