require 'vertx/pipe'
require 'vertx/write_stream'
require 'vertx/read_stream'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.sql.SQLRowStream
module VertxSql
  #  A ReadStream of Rows from the underlying RDBMS. This class follows the ReadStream semantics and will automatically
  #  close the underlying resources if all returned rows are returned. For cases where the results are ignored before the
  #  full processing of the returned rows is complete the close method **MUST** be called in order to release underlying
  #  resources.
  # 
  #  The interface is minimal in order to support all SQL clients not just JDBC.
  class SQLRowStream
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxSql::SQLRowStream] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSql::SQLRowStream] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == SQLRowStream
    end
    def @@j_api_type.wrap(obj)
      SQLRowStream.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtSql::SQLRowStream.java_class
    end
    #  Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
    #  recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
    #  be added to the current stream demand.
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe, nil)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class]).call(dst.j_del)
      elsif dst.class.method_defined?(:j_del) && block_given?
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @yield 
    # @return [self]
    def handler
      if block_given?
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(event != nil ? JSON.parse(event.encode) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    # @yield 
    # @return [self]
    def end_handler
      if block_given?
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    #  Will convert the column name to the json array index.
    # @param [String] name the column name
    # @return [Fixnum] the json array index
    def column(name=nil)
      if name.class == String && !block_given?
        return @j_del.java_method(:column, [Java::java.lang.String.java_class]).call(name)
      end
      raise ArgumentError, "Invalid arguments when calling column(#{name})"
    end
    #  Returns all column names available in the underlying resultset. One needs to carefully use this method since in
    #  contrast to the singular version it does not perform case insensitive lookups or takes alias in consideration on
    #  the column names.
    # @return [Array<String>] the list of columns names returned by the query
    def columns
      if !block_given?
        return @j_del.java_method(:columns, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling columns()"
    end
    #  Event handler when a resultset is closed. This is useful to request for more results.
    # @yield called when the current result set is closed
    # @return [self]
    def result_set_closed_handler
      if block_given?
        @j_del.java_method(:resultSetClosedHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling result_set_closed_handler()"
    end
    #  Request for more results if available
    # @return [void]
    def more_results
      if !block_given?
        return @j_del.java_method(:moreResults, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling more_results()"
    end
    #  Closes the stream/underlying cursor(s). The actual close happens asynchronously.
    # @yield called when the stream/underlying cursor(s) is(are) closed
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      elsif block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
