require 'vertx/buffer'
require 'vertx-sql-client/tuple'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.Row
module VertxSqlClient
  #  Represents single row of the result set.
  class Row < ::VertxSqlClient::Tuple
    # @private
    # @param j_del [::VertxSqlClient::Row] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::Row] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Row
    end
    def @@j_api_type.wrap(obj)
      Row.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclient::Row.java_class
    end
    #  Get an object value for the given <code>column</code>.
    # @overload getValue(pos)
    #   @param [Fixnum] pos the position
    # @overload getValue(column)
    #   @param [String] column the column name
    # @return [Object] the <code>column</code> value
    def get_value(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getValue, [Java::int.java_class]).call(param_1))
      elsif param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:getValue, [Java::java.lang.String.java_class]).call(param_1))
      end
      raise ArgumentError, "Invalid arguments when calling get_value(#{param_1})"
    end
    #  Get a boolean value for the given <code>column</code>.
    # @overload getBoolean(pos)
    #   @param [Fixnum] pos the position
    # @overload getBoolean(column)
    #   @param [String] column the column name
    # @return [true,false] the <code>column</code> value
    def get_boolean?(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getBoolean, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getBoolean, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_boolean?(#{param_1})"
    end
    #  Get a short value for the given <code>column</code>.
    # @overload getShort(pos)
    #   @param [Fixnum] pos the position
    # @overload getShort(column)
    #   @param [String] column the column name
    # @return [Fixnum] the <code>column</code> value
    def get_short(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getShort, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getShort, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_short(#{param_1})"
    end
    #  Get an integer value for the given <code>column</code>.
    # @overload getInteger(pos)
    #   @param [Fixnum] pos the position
    # @overload getInteger(column)
    #   @param [String] column the column name
    # @return [Fixnum] the <code>column</code> value
    def get_integer(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getInteger, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getInteger, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_integer(#{param_1})"
    end
    #  Get a long value for the given <code>column</code>.
    # @overload getLong(pos)
    #   @param [Fixnum] pos the position
    # @overload getLong(column)
    #   @param [String] column the column name
    # @return [Fixnum] the <code>column</code> value
    def get_long(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getLong, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getLong, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_long(#{param_1})"
    end
    #  Get a float value for the given <code>column</code>.
    # @overload getFloat(pos)
    #   @param [Fixnum] pos the position
    # @overload getFloat(column)
    #   @param [String] column the column name
    # @return [Float] the <code>column</code> value
    def get_float(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getFloat, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getFloat, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_float(#{param_1})"
    end
    #  Get a double value for the given <code>column</code>.
    # @overload getDouble(pos)
    #   @param [Fixnum] pos the position
    # @overload getDouble(column)
    #   @param [String] column the column name
    # @return [Float] the <code>column</code> value
    def get_double(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getDouble, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getDouble, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_double(#{param_1})"
    end
    #  Get a string value for the given <code>column</code>.
    # @overload getString(pos)
    #   @param [Fixnum] pos the position
    # @overload getString(column)
    #   @param [String] column the column name
    # @return [String] the <code>column</code> value
    def get_string(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return @j_del.java_method(:getString, [Java::int.java_class]).call(param_1)
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:getString, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling get_string(#{param_1})"
    end
    #  Get a buffer value for the given <code>column</code>.
    # @overload getBuffer(pos)
    #   @param [Fixnum] pos the position
    # @overload getBuffer(column)
    #   @param [String] column the column name
    # @return [::Vertx::Buffer] the <code>column</code> value
    def get_buffer(param_1=nil)
      if param_1.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::int.java_class]).call(param_1),::Vertx::Buffer)
      elsif param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:getBuffer, [Java::java.lang.String.java_class]).call(param_1),::Vertx::Buffer)
      end
      raise ArgumentError, "Invalid arguments when calling get_buffer(#{param_1})"
    end
    #  Add an object value at the end of the tuple.
    # @param [Object] value the value
    # @return [self]
    def add_value(value=nil)
      if ::Vertx::Util::unknown_type.accept?(value) && !block_given?
        @j_del.java_method(:addValue, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_value(#{value})"
    end
    #  Add a boolean value at the end of the tuple.
    # @param [true,false] value the value
    # @return [self]
    def add_boolean(value=nil)
      if (value.class == TrueClass || value.class == FalseClass) && !block_given?
        @j_del.java_method(:addBoolean, [Java::JavaLang::Boolean.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_boolean(#{value})"
    end
    #  Add a short value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_short(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addShort, [Java::JavaLang::Short.java_class]).call(::Vertx::Util::Utils.to_short(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_short(#{value})"
    end
    #  Add an integer value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_integer(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addInteger, [Java::JavaLang::Integer.java_class]).call(::Vertx::Util::Utils.to_integer(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_integer(#{value})"
    end
    #  Add a long value at the end of the tuple.
    # @param [Fixnum] value the value
    # @return [self]
    def add_long(value=nil)
      if value.class == Fixnum && !block_given?
        @j_del.java_method(:addLong, [Java::JavaLang::Long.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_long(#{value})"
    end
    #  Add a float value at the end of the tuple.
    # @param [Float] value the value
    # @return [self]
    def add_float(value=nil)
      if value.class == Float && !block_given?
        @j_del.java_method(:addFloat, [Java::JavaLang::Float.java_class]).call(::Vertx::Util::Utils.to_float(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_float(#{value})"
    end
    #  Add a double value at the end of the tuple.
    # @param [Float] value the value
    # @return [self]
    def add_double(value=nil)
      if value.class == Float && !block_given?
        @j_del.java_method(:addDouble, [Java::JavaLang::Double.java_class]).call(::Vertx::Util::Utils.to_double(value))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_double(#{value})"
    end
    #  Add a string value at the end of the tuple.
    # @param [String] value the value
    # @return [self]
    def add_string(value=nil)
      if value.class == String && !block_given?
        @j_del.java_method(:addString, [Java::java.lang.String.java_class]).call(value)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_string(#{value})"
    end
    #  Add a buffer value at the end of the tuple.
    # @param [::Vertx::Buffer] value the value
    # @return [self]
    def add_buffer(value=nil)
      if value.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:addBuffer, [Java::IoVertxCoreBuffer::Buffer.java_class]).call(value.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling add_buffer(#{value})"
    end
    # @param [Nil] type 
    # @param [Fixnum] pos 
    # @return [Object]
    def get(type=nil,pos=nil)
      if type.class == Class && pos.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.v_type_of(type).wrap(@j_del.java_method(:get, [Java::JavaLang::Class.java_class,Java::int.java_class]).call(::Vertx::Util::Utils.j_class_of(type),pos))
      end
      raise ArgumentError, "Invalid arguments when calling get(#{type},#{pos})"
    end
    # @return [Fixnum] the tuple size
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size()"
    end
    # @return [void]
    def clear
      if !block_given?
        return @j_del.java_method(:clear, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling clear()"
    end
    # @return [String] A String containing the toString value of each element, separated by a comma (,) character
    def deep_to_string
      if !block_given?
        return @j_del.java_method(:deepToString, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling deep_to_string()"
    end
    #  Get a column name for the given <code>column</code>.
    # @param [Fixnum] pos the column position
    # @return [String] the column name or <code>null</code>
    def get_column_name(pos=nil)
      if pos.class == Fixnum && !block_given?
        return @j_del.java_method(:getColumnName, [Java::int.java_class]).call(pos)
      end
      raise ArgumentError, "Invalid arguments when calling get_column_name(#{pos})"
    end
    #  Get a column position for the given column <code>name</code>.
    # @param [String] name the column name
    # @return [Fixnum] the column name or <code>-1</code> if not found
    def get_column_index(name=nil)
      if name.class == String && !block_given?
        return @j_del.java_method(:getColumnIndex, [Java::java.lang.String.java_class]).call(name)
      end
      raise ArgumentError, "Invalid arguments when calling get_column_index(#{name})"
    end
    #  The JSON null literal value.
    #  <br/>
    #  It is used to distinguish a JSON null literal value from the Java <code>null</code> value. This is only
    #  used when the database supports JSON types.
    def self.JSON_NULL
      ::Vertx::Util::Utils.from_object(Java::IoVertxSqlclient::Row.JSON_NULL)
    end
  end
end
