require 'vertx-sql-client/property_kind'
require 'vertx-sql-client/column_descriptor'
require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.SqlResult
module VertxSqlClient
  #  Represents the result of an operation on database.
  class SqlResult
    # @private
    # @param j_del [::VertxSqlClient::SqlResult] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::VertxSqlClient::SqlResult] the underlying java delegate
    def j_del
      @j_del
    end
    #  Get the number of the affected rows in the operation to this SqlResult.
    # @return [Fixnum] the count of affected rows.
    def row_count
      if !block_given?
        return @j_del.java_method(:rowCount, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling row_count()"
    end
    #  Get the names of columns in the SqlResult.
    # @return [Array<String>] the list of names of columns.
    def columns_names
      if !block_given?
        return @j_del.java_method(:columnsNames, []).call().to_a.map { |elt| elt }
      end
      raise ArgumentError, "Invalid arguments when calling columns_names()"
    end
    #  Get the column descriptors in the SqlResult.
    # @return [Array<::VertxSqlClient::ColumnDescriptor>] the list of column descriptors
    def column_descriptors
      if !block_given?
        return @j_del.java_method(:columnDescriptors, []).call().to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxSqlClient::ColumnDescriptor) }
      end
      raise ArgumentError, "Invalid arguments when calling column_descriptors()"
    end
    #  Get the number of rows retrieved in the SqlResult.
    # @return [Fixnum] the count of rows.
    def size
      if !block_given?
        return @j_del.java_method(:size, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling size()"
    end
    #  Get the property with the specified {::VertxSqlClient::PropertyKind}.
    # @param [::VertxSqlClient::PropertyKind] propertyKind the kind of the property
    # @return [Object] the value of the property
    def property(propertyKind=nil)
      if propertyKind.class.method_defined?(:j_del) && !block_given?
        return ::Vertx::Util::Utils.from_object(@j_del.java_method(:property, [Java::IoVertxSqlclient::PropertyKind.java_class]).call(propertyKind.j_del))
      end
      raise ArgumentError, "Invalid arguments when calling property(#{propertyKind})"
    end
    #  Get the result value.
    # @return [Object] the result
    def value
      if !block_given?
        return @j_arg_T.wrap(@j_del.java_method(:value, []).call())
      end
      raise ArgumentError, "Invalid arguments when calling value()"
    end
    #  Return the next available result or <code>null</code>, e.g for a simple query that executed multiple queries or for
    #  a batch result.
    # @return [::VertxSqlClient::SqlResult] the next available result or <code>null</code> if none is available
    def next
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:next, []).call(),::VertxSqlClient::SqlResult, nil)
      end
      raise ArgumentError, "Invalid arguments when calling next()"
    end
  end
end
