require 'vertx/promise'
require 'vertx/util/utils.rb'
# Generated from io.vertx.core.Future
module Vertx
  #  Represents the result of an action that may, or may not, have occurred yet.
  #  <p>
  class Future
    # @private
    # @param j_del [::Vertx::Future] the java delegate
    def initialize(j_del, j_arg_T=nil)
      @j_del = j_del
      @j_arg_T = j_arg_T != nil ? j_arg_T : ::Vertx::Util::unknown_type
    end
    # @private
    # @return [::Vertx::Future] the underlying java delegate
    def j_del
      @j_del
    end
    #  Create a future that hasn't completed yet and that is passed to the <code>handler</code> before it is returned.
    # @yield the handler
    # @return [::Vertx::Future] the future.
    def self.future
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Future.java_method(:future, []).call(),::Vertx::Future, nil)
      elsif block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Future.java_method(:future, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::Vertx::Promise, nil)) })),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling future()"
    end
    #  Created a succeeded future with the specified result.
    # @param [Object] result the result
    # @return [::Vertx::Future] the future
    def self.succeeded_future(result=nil)
      if !block_given? && result == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Future.java_method(:succeededFuture, []).call(),::Vertx::Future, nil)
      elsif ::Vertx::Util::unknown_type.accept?(result) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Future.java_method(:succeededFuture, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(result)),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling succeeded_future(#{result})"
    end
    #  Create a failed future with the specified failure message.
    # @overload failedFuture(t)
    #   @param [Exception] t the failure cause as a Throwable
    # @overload failedFuture(failureMessage)
    #   @param [String] failureMessage the failure message
    # @return [::Vertx::Future] the future
    def self.failed_future(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Future.java_method(:failedFuture, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1)),::Vertx::Future, nil)
      elsif param_1.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxCore::Future.java_method(:failedFuture, [Java::java.lang.String.java_class]).call(param_1),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling failed_future(#{param_1})"
    end
    #  Has the future completed?
    #  <p>
    #  It's completed if it's either succeeded or failed.
    # @return [true,false] true if completed, false if not
    def complete?
      if !block_given?
        return @j_del.java_method(:isComplete, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling complete?()"
    end
    #  Like {::Vertx::Future#on_complete}.
    # @yield 
    # @return [self]
    def set_handler
      if block_given?
        @j_del.java_method(:setHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_handler()"
    end
    #  Add a handler to be notified of the result.
    #  <br/>
    # @yield the handler that will be called with the result
    # @return [self]
    def on_complete
      if block_given?
        @j_del.java_method(:onComplete, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? @j_arg_T.wrap(ar.result) : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling on_complete()"
    end
    #  Add a handler to be notified of the succeeded result.
    #  <br/>
    # @yield the handler that will be called with the succeeded result
    # @return [self]
    def on_success
      if block_given?
        @j_del.java_method(:onSuccess, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(@j_arg_T.wrap(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling on_success()"
    end
    #  Add a handler to be notified of the failed result.
    #  <br/>
    # @yield the handler that will be called with the failed result
    # @return [self]
    def on_failure
      if block_given?
        @j_del.java_method(:onFailure, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling on_failure()"
    end
    #  Set the result. Any handler will be called, if there is one, and the future will be marked as completed.
    # @param [Object] result the result
    # @return [void]
    def complete(result=nil)
      if !block_given? && result == nil
        return @j_del.java_method(:complete, []).call()
      elsif @j_arg_T.accept?(result) && !block_given?
        return @j_del.java_method(:complete, [Java::java.lang.Object.java_class]).call(@j_arg_T.unwrap(result))
      end
      raise ArgumentError, "Invalid arguments when calling complete(#{result})"
    end
    #  Try to set the failure. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
    # @overload fail(cause)
    #   @param [Exception] cause the failure cause
    # @overload fail(failureMessage)
    #   @param [String] failureMessage the failure message
    # @return [void]
    def fail(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return @j_del.java_method(:fail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1))
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:fail, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling fail(#{param_1})"
    end
    #  Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
    # @param [Object] result the result
    # @return [true,false] false when the future is already completed
    def try_complete?(result=nil)
      if !block_given? && result == nil
        return @j_del.java_method(:tryComplete, []).call()
      elsif @j_arg_T.accept?(result) && !block_given?
        return @j_del.java_method(:tryComplete, [Java::java.lang.Object.java_class]).call(@j_arg_T.unwrap(result))
      end
      raise ArgumentError, "Invalid arguments when calling try_complete?(#{result})"
    end
    #  Try to set the failure. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
    # @overload tryFail(cause)
    #   @param [Exception] cause the failure cause
    # @overload tryFail(failureMessage)
    #   @param [String] failureMessage the failure message
    # @return [true,false] false when the future is already completed
    def try_fail?(param_1=nil)
      if param_1.is_a?(Exception) && !block_given?
        return @j_del.java_method(:tryFail, [Java::JavaLang::Throwable.java_class]).call(::Vertx::Util::Utils.to_throwable(param_1))
      elsif param_1.class == String && !block_given?
        return @j_del.java_method(:tryFail, [Java::java.lang.String.java_class]).call(param_1)
      end
      raise ArgumentError, "Invalid arguments when calling try_fail?(#{param_1})"
    end
    #  The result of the operation. This will be null if the operation failed.
    # @return [Object] the result or null if the operation failed.
    def result
      if !block_given?
        return @j_arg_T.wrap(@j_del.java_method(:result, []).call())
      end
      raise ArgumentError, "Invalid arguments when calling result()"
    end
    #  A Throwable describing failure. This will be null if the operation succeeded.
    # @return [Exception] the cause or null if the operation succeeded.
    def cause
      if !block_given?
        return ::Vertx::Util::Utils.from_throwable(@j_del.java_method(:cause, []).call())
      end
      raise ArgumentError, "Invalid arguments when calling cause()"
    end
    #  Did it succeed?
    # @return [true,false] true if it succeded or false otherwise
    def succeeded?
      if !block_given?
        return @j_del.java_method(:succeeded, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling succeeded?()"
    end
    #  Did it fail?
    # @return [true,false] true if it failed or false otherwise
    def failed?
      if !block_given?
        return @j_del.java_method(:failed, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling failed?()"
    end
    #  Alias for {::Vertx::Future#compose}.
    # @yield 
    # @return [::Vertx::Future]
    def flat_map(mapper=nil)
      if block_given? && mapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:flatMap, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(@j_arg_T.wrap(event)).j_del })),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling flat_map(#{mapper})"
    end
    #  Compose this future with a <code>successMapper</code> and <code>failureMapper</code> functions.<p>
    #  <p>
    #  When this future (the one on which <code>compose</code> is called) succeeds, the <code>successMapper</code> will be called with
    #  the completed value and this mapper returns another future object. This returned future completion will complete
    #  the future returned by this method call.<p>
    #  <p>
    #  When this future (the one on which <code>compose</code> is called) fails, the <code>failureMapper</code> will be called with
    #  the failure and this mapper returns another future object. This returned future completion will complete
    #  the future returned by this method call.<p>
    #  <p>
    #  If any mapper function throws an exception, the returned future will be failed with this exception.<p>
    # @param [Proc] successMapper the function mapping the success
    # @yield the function mapping the failure
    # @return [::Vertx::Future] the composed future
    def compose(successMapper=nil,failureMapper=nil)
      if block_given? && successMapper == nil && failureMapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:compose, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(@j_arg_T.wrap(event)).j_del })),::Vertx::Future, nil)
      elsif successMapper.class == Proc && block_given? && failureMapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:compose, [Java::JavaUtilFunction::Function.java_class,Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| successMapper.call(@j_arg_T.wrap(event)).j_del }),(Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del })),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling compose(#{successMapper},#{failureMapper})"
    end
    #  Map the result of a future to a specific <code>value</code>.<p>
    #  <p>
    #  When this future succeeds, this <code>value</code> will complete the future returned by this method call.<p>
    #  <p>
    #  When this future fails, the failure will be propagated to the returned future.
    # @overload map(mapper)
    #   @yield the mapper function
    # @overload map(value)
    #   @param [Object] value the value that eventually completes the mapped future
    # @return [::Vertx::Future] the mapped future
    def map(param_1=nil)
      if block_given? && param_1 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:map, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| ::Vertx::Util::Utils.to_object(yield(@j_arg_T.wrap(event))) })),::Vertx::Future, nil)
      elsif ::Vertx::Util::unknown_type.accept?(param_1) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:map, [Java::java.lang.Object.java_class]).call(::Vertx::Util::Utils.to_object(param_1)),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling map(#{param_1})"
    end
    #  Map the result of a future to <code>null</code>.<p>
    #  <p>
    #  This is a conveniency for <code>future.map((T) null)</code> or <code>future.map((Void) null)</code>.<p>
    #  <p>
    #  When this future succeeds, <code>null</code> will complete the future returned by this method call.<p>
    #  <p>
    #  When this future fails, the failure will be propagated to the returned future.
    # @return [::Vertx::Future] the mapped future
    def map_empty
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:mapEmpty, []).call(),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling map_empty()"
    end
    # @return [Proc] an handler completing this future
    def completer
      if !block_given?
        if @cached_completer != nil
          return @cached_completer
        end
        return @cached_completer = ::Vertx::Util::Utils.to_async_result_handler_proc(@j_del.java_method(:completer, []).call()) { |val| @j_arg_T.unwrap(val) }
      end
      raise ArgumentError, "Invalid arguments when calling completer()"
    end
    #  Handles a failure of this Future by returning the result of another Future.
    #  If the mapper fails, then the returned future will be failed with this failure.
    # @yield A function which takes the exception of a failure and returns a new future.
    # @return [::Vertx::Future] A recovered future
    def recover(mapper=nil)
      if block_given? && mapper == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:recover, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)).j_del })),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling recover(#{mapper})"
    end
    #  Map the failure of a future to a specific <code>value</code>.<p>
    #  <p>
    #  When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
    #  <p>
    #  When this future succeeds, the result will be propagated to the returned future.
    # @overload otherwise(mapper)
    #   @yield the mapper function
    # @overload otherwise(value)
    #   @param [Object] value the value that eventually completes the mapped future
    # @return [::Vertx::Future] the mapped future
    def otherwise(param_1=nil)
      if block_given? && param_1 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::JavaUtilFunction::Function.java_class]).call((Proc.new { |event| @j_arg_T.unwrap(yield(::Vertx::Util::Utils.from_throwable(event))) })),::Vertx::Future, nil)
      elsif @j_arg_T.accept?(param_1) && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwise, [Java::java.lang.Object.java_class]).call(@j_arg_T.unwrap(param_1)),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling otherwise(#{param_1})"
    end
    #  Map the failure of a future to <code>null</code>.<p>
    #  <p>
    #  This is a convenience for <code>future.otherwise((T) null)</code>.<p>
    #  <p>
    #  When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
    #  <p>
    #  When this future succeeds, the result will be propagated to the returned future.
    # @return [::Vertx::Future] the mapped future
    def otherwise_empty
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:otherwiseEmpty, []).call(),::Vertx::Future, nil)
      end
      raise ArgumentError, "Invalid arguments when calling otherwise_empty()"
    end
  end
end
