require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.web.common.WebEnvironment
module VertxWebCommon
  #  Utility API to verify which environment is the web application running.
  # 
  #  The utility will check initially for the existence of a system property under the name `vertx.mode`,
  #  if there is no such property then it will look under the environment variables under the name `VERTX_MODE`.
  # 
  #  This value will be then used when the API is invoked. By itself this utility will not
  #  affect the behavior of your application, however you can use it to simplify your handlers, e.g.:
  # 
  #  When the development mode is active you can log more information or disable caches.
  class WebEnvironment
    # @private
    # @param j_del [::VertxWebCommon::WebEnvironment] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxWebCommon::WebEnvironment] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == WebEnvironment
    end
    def @@j_api_type.wrap(obj)
      WebEnvironment.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtWebCommon::WebEnvironment.java_class
    end
    #  Will return true if the mode is not null and equals ignoring case the string "dev"
    # @return [true,false] always boolean
    def self.development?
      if !block_given?
        return Java::IoVertxExtWebCommon::WebEnvironment.java_method(:development, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling development?()"
    end
    #  The current mode from the system properties with fallback to environment variables
    # @return [String] String with mode value or null
    def self.mode
      if !block_given?
        return Java::IoVertxExtWebCommon::WebEnvironment.java_method(:mode, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling mode()"
    end
    def self.SYSTEM_PROPERTY_NAME
      Java::IoVertxExtWebCommon::WebEnvironment.SYSTEM_PROPERTY_NAME
    end
    def self.ENV_VARIABLE_NAME
      Java::IoVertxExtWebCommon::WebEnvironment.ENV_VARIABLE_NAME
    end
  end
end
