require 'vertx-amqp-client/amqp_message'
require 'vertx/write_stream'
require 'vertx-amqp-client/amqp_connection'
require 'vertx/util/utils.rb'
# Generated from io.vertx.amqp.AmqpSender
module VertxAmqpClient
  #  AMQP Sender interface used to send messages.
  class AmqpSender
    include ::Vertx::WriteStream
    # @private
    # @param j_del [::VertxAmqpClient::AmqpSender] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAmqpClient::AmqpSender] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == AmqpSender
    end
    def @@j_api_type.wrap(obj)
      AmqpSender.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxAmqp::AmqpSender.java_class
    end
    #  Same as  but with an <code>handler</code> called when the operation completes
    # @param [::VertxAmqpClient::AmqpMessage] data 
    # @yield 
    # @return [void]
    def end(data=nil)
      if !block_given? && data == nil
        return @j_del.java_method(:end, []).call()
      elsif block_given? && data == nil
        return @j_del.java_method(:end, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      elsif data.class.method_defined?(:j_del) && !block_given?
        return @j_del.java_method(:end, [Java::IoVertxAmqp::AmqpMessage.java_class]).call(data.j_del)
      elsif data.class.method_defined?(:j_del) && block_given?
        return @j_del.java_method(:end, [Java::IoVertxAmqp::AmqpMessage.java_class,Java::IoVertxCore::Handler.java_class]).call(data.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling end(#{data})"
    end
    #  This will return <code>true</code> if there are more bytes in the write queue than the value set using {::VertxAmqpClient::AmqpSender#set_write_queue_max_size}
    # @return [true,false] true if write queue is full
    def write_queue_full?
      if !block_given?
        return @j_del.java_method(:writeQueueFull, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling write_queue_full?()"
    end
    #  Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
    #  queue is ready to accept buffers again. See  for an example of this being used.
    #  <p/>
    #  The stream implementation defines when the drain handler, for example it could be when the queue size has been
    #  reduced to <code>maxSize / 2</code>.
    # @yield the handler
    # @return [self]
    def drain_handler
      if block_given?
        @j_del.java_method(:drainHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling drain_handler()"
    end
    # @param [::VertxAmqpClient::AmqpMessage] data 
    # @yield 
    # @return [self]
    def write(data=nil)
      if data.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:write, [Java::IoVertxAmqp::AmqpMessage.java_class]).call(data.j_del)
        return self
      elsif data.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:write, [Java::IoVertxAmqp::AmqpMessage.java_class,Java::IoVertxCore::Handler.java_class]).call(data.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling write(#{data})"
    end
    # @yield 
    # @return [self]
    def exception_handler
      if block_given?
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    # @param [Fixnum] maxSize 
    # @return [self]
    def set_write_queue_max_size(maxSize=nil)
      if maxSize.class == Fixnum && !block_given?
        @j_del.java_method(:setWriteQueueMaxSize, [Java::int.java_class]).call(maxSize)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling set_write_queue_max_size(#{maxSize})"
    end
    #  Sends an AMQP message. The destination the configured sender address or the address configured in the message.
    # @param [::VertxAmqpClient::AmqpMessage] message the message, must not be <code>null</code>
    # @return [self]
    def send(message=nil)
      if message.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:send, [Java::IoVertxAmqp::AmqpMessage.java_class]).call(message.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling send(#{message})"
    end
    #  Sends an AMQP message and waits for an acknowledgement. The acknowledgement handler is called with an
    #   marked as failed if the message has been rejected or re-routed. If the message has been accepted,
    #  the handler is called with a success.
    # @param [::VertxAmqpClient::AmqpMessage] message the message, must not be <code>null</code>
    # @yield the acknowledgement handler, must not be <code>null</code>
    # @return [self]
    def send_with_ack(message=nil)
      if message.class.method_defined?(:j_del) && block_given?
        @j_del.java_method(:sendWithAck, [Java::IoVertxAmqp::AmqpMessage.java_class,Java::IoVertxCore::Handler.java_class]).call(message.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling send_with_ack(#{message})"
    end
    #  Closes the sender.
    # @yield called when the sender has been closed, must not be <code>null</code>
    # @return [void]
    def close
      if block_given?
        return @j_del.java_method(:close, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
    # @return [String] the configured address.
    def address
      if !block_given?
        return @j_del.java_method(:address, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling address()"
    end
    #  Gets the connection having created the sender. Cannot be <code>null</code>
    # @return [::VertxAmqpClient::AmqpConnection] the connection having created the sender.
    def connection
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:connection, []).call(),::VertxAmqpClient::AmqpConnection)
      end
      raise ArgumentError, "Invalid arguments when calling connection()"
    end
    # @return [Fixnum] the remaining credit, 0 is none.
    def remaining_credits
      if !block_given?
        return @j_del.java_method(:remainingCredits, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling remaining_credits()"
    end
  end
end
