require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.desc.ColumnDescriptor
module VertxSqlClient
  class ColumnDescriptor
    # @private
    # @param j_del [::VertxSqlClient::ColumnDescriptor] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::ColumnDescriptor] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == ColumnDescriptor
    end
    def @@j_api_type.wrap(obj)
      ColumnDescriptor.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclientDesc::ColumnDescriptor.java_class
    end
    # @return [String] the column name
    def name
      if !block_given?
        return @j_del.java_method(:name, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling name()"
    end
    # @return [true,false] whether the column is an array
    def array?
      if !block_given?
        return @j_del.java_method(:isArray, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling array?()"
    end
    # @return [:BIT,:TINYINT,:SMALLINT,:INTEGER,:BIGINT,:FLOAT,:REAL,:DOUBLE,:NUMERIC,:DECIMAL,:CHAR,:VARCHAR,:LONGVARCHAR,:DATE,:TIME,:TIMESTAMP,:BINARY,:VARBINARY,:LONGVARBINARY,:NULL,:OTHER,:JAVA_OBJECT,:DISTINCT,:STRUCT,:ARRAY,:BLOB,:CLOB,:REF,:DATALINK,:BOOLEAN,:ROWID,:NCHAR,:NVARCHAR,:LONGNVARCHAR,:NCLOB,:SQLXML,:REF_CURSOR,:TIME_WITH_TIMEZONE,:TIMESTAMP_WITH_TIMEZONE] the most appropriate <code>JDBCType</code>
    def jdbc_type
      if !block_given?
        return @j_del.java_method(:jdbcType, []).call().name.intern
      end
      raise ArgumentError, "Invalid arguments when calling jdbc_type()"
    end
  end
end
