require 'vertx/util/utils.rb'
# Generated from io.vertx.sqlclient.spi.DatabaseMetadata
module VertxSqlClient
  #  Contains static metadata about the backend database server 
  class DatabaseMetadata
    # @private
    # @param j_del [::VertxSqlClient::DatabaseMetadata] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxSqlClient::DatabaseMetadata] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == DatabaseMetadata
    end
    def @@j_api_type.wrap(obj)
      DatabaseMetadata.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxSqlclientSpi::DatabaseMetadata.java_class
    end
    # @return [String] The product name of the backend database server
    def product_name
      if !block_given?
        return @j_del.java_method(:productName, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling product_name()"
    end
    # @return [String] The full version string for the backend database server. This may be useful for for parsing more subtle aspects of the version string. For simple information like database major and minor version, use {::VertxSqlClient::DatabaseMetadata#major_version} and {::VertxSqlClient::DatabaseMetadata#minor_version} instead.
    def full_version
      if !block_given?
        return @j_del.java_method(:fullVersion, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling full_version()"
    end
    # @return [Fixnum] The major version of the backend database server
    def major_version
      if !block_given?
        return @j_del.java_method(:majorVersion, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling major_version()"
    end
    # @return [Fixnum] The minor version of the backend database server
    def minor_version
      if !block_given?
        return @j_del.java_method(:minorVersion, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling minor_version()"
    end
  end
end
