require 'vertx/vertx'
require 'vertx-auth-oauth2/o_auth2_rbac'
require 'vertx-auth-oauth2/access_token'
require 'vertx-auth-common/auth_provider'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.OAuth2Auth
module VertxAuthOauth2
  #  Factory interface for creating OAuth2 based {::VertxAuthCommon::AuthProvider} instances.
  class OAuth2Auth < ::VertxAuthCommon::AuthProvider
    # @private
    # @param j_del [::VertxAuthOauth2::OAuth2Auth] the java delegate
    def initialize(j_del)
      super(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::OAuth2Auth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == OAuth2Auth
    end
    def @@j_api_type.wrap(obj)
      OAuth2Auth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2::OAuth2Auth.java_class
    end
    #  Authenticate a user.
    #  <p>
    #  The first argument is a JSON object containing information for authenticating the user. What this actually contains
    #  depends on the specific implementation. In the case of a simple username/password based
    #  authentication it is likely to contain a JSON object with the following structure:
    #  <pre>
    #    {
    #      "username": "tim",
    #      "password": "mypassword"
    #    }
    #  </pre>
    #  For other types of authentication it contain different information - for example a JWT token or OAuth bearer token.
    #  <p>
    #  If the user is successfully authenticated a  object is passed to the handler in an {AsyncResult}.
    #  The user object can then be used for authorisation.
    # @param [Hash{String => Object}] authInfo The auth information
    # @yield The result handler
    # @return [void]
    def authenticate(authInfo=nil)
      if authInfo.class == Hash && true
        return @j_del.java_method(:authenticate, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(authInfo),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthCommon::User) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling authenticate(#{authInfo})"
    end
    # @param [::Vertx::Vertx] vertx the Vertx instance
    # @param [:AUTH_CODE,:CLIENT,:PASSWORD,:AUTH_JWT] flow 
    # @param [Hash{String => Object}] config the config as exported from the admin console
    # @return [::VertxAuthOauth2::OAuth2Auth] the auth provider
    def self.create_keycloak(vertx=nil,flow=nil,config=nil)
      if vertx.class.method_defined?(:j_del) && flow.class == Symbol && config.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:createKeycloak, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2FlowType.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(vertx.j_del,Java::IoVertxExtAuthOauth2::OAuth2FlowType.valueOf(flow.to_s),::Vertx::Util::Utils.to_json_object(config)),::VertxAuthOauth2::OAuth2Auth)
      end
      raise ArgumentError, "Invalid arguments when calling create_keycloak(#{vertx},#{flow},#{config})"
    end
    #  Create a OAuth2 auth provider
    # @overload create(vertx)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    # @overload create(vertx,flow)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    #   @param [:AUTH_CODE,:CLIENT,:PASSWORD,:AUTH_JWT] flow 
    # @overload create(vertx,config)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    #   @param [Hash{String => Object}] config the config
    # @overload create(vertx,flow,config)
    #   @param [::Vertx::Vertx] vertx the Vertx instance
    #   @param [:AUTH_CODE,:CLIENT,:PASSWORD,:AUTH_JWT] flow 
    #   @param [Hash{String => Object}] config the config
    # @return [::VertxAuthOauth2::OAuth2Auth] the auth provider
    def self.create(param_1=nil,param_2=nil,param_3=nil)
      if param_1.class.method_defined?(:j_del) && !block_given? && param_2 == nil && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:create, [Java::IoVertxCore::Vertx.java_class]).call(param_1.j_del),::VertxAuthOauth2::OAuth2Auth)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Symbol && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2FlowType.java_class]).call(param_1.j_del,Java::IoVertxExtAuthOauth2::OAuth2FlowType.valueOf(param_2.to_s)),::VertxAuthOauth2::OAuth2Auth)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && !block_given? && param_3 == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.java_class]).call(param_1.j_del,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxAuthOauth2::OAuth2Auth)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Symbol && param_3.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtAuthOauth2::OAuth2Auth.java_method(:create, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2FlowType.java_class,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.java_class]).call(param_1.j_del,Java::IoVertxExtAuthOauth2::OAuth2FlowType.valueOf(param_2.to_s),Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.new(::Vertx::Util::Utils.to_json_object(param_3))),::VertxAuthOauth2::OAuth2Auth)
      end
      raise ArgumentError, "Invalid arguments when calling create(#{param_1},#{param_2},#{param_3})"
    end
    #  Generate a redirect URL to the authN/Z backend. It only applies to auth_code flow.
    # @param [Hash{String => Object}] params 
    # @return [String]
    def authorize_url(params=nil)
      if params.class == Hash && !block_given?
        return @j_del.java_method(:authorizeURL, [Java::IoVertxCoreJson::JsonObject.java_class]).call(::Vertx::Util::Utils.to_json_object(params))
      end
      raise ArgumentError, "Invalid arguments when calling authorize_url(#{params})"
    end
    #  Returns the Access Token object.
    # @param [Hash{String => Object}] params - JSON with the options, each flow requires different options.
    # @yield - The handler returning the results.
    # @return [void]
    def get_token(params=nil)
      if params.class == Hash && true
        return @j_del.java_method(:getToken, [Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(::Vertx::Util::Utils.to_json_object(params),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling get_token(#{params})"
    end
    #  Decode a token to a {::VertxAuthOauth2::AccessToken} object. This is useful to handle bearer JWT tokens.
    # @param [String] token the access token (base64 string)
    # @yield A handler to receive the event
    # @return [self]
    def decode_token(token=nil)
      if token.class == String && true
        @j_del.java_method(:decodeToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(token,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling decode_token(#{token})"
    end
    #  Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
    #  meta-information about this token.
    # @param [String] token the access token (base64 string)
    # @param [String] tokenType hint to the token type e.g.: `access_token`
    # @yield A handler to receive the event
    # @return [self]
    def introspect_token(token=nil,tokenType=nil)
      if token.class == String && true && tokenType == nil
        @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(token,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } unless !block_given?))
        return self
      elsif token.class == String && tokenType.class == String && true
        @j_del.java_method(:introspectToken, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(token,tokenType,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::AccessToken) : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling introspect_token(#{token},#{tokenType})"
    end
    #  Returns the scope separator.
    # 
    #  The RFC 6749 states that a scope is expressed as a set of case-sensitive and space-delimited strings, however
    #  vendors tend not to agree on this and we see the following cases being used: space, plus sign, comma.
    # @return [String] what value was used in the configuration of the object, falling back to the default value which is a space.
    def get_scope_separator
      if !block_given?
        return @j_del.java_method(:getScopeSeparator, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling get_scope_separator()"
    end
    #  Returns the configured flow type for the Oauth2 provider.
    # @return [:AUTH_CODE,:CLIENT,:PASSWORD,:AUTH_JWT] the flow type.
    def get_flow_type
      if !block_given?
        return @j_del.java_method(:getFlowType, []).call().name.intern
      end
      raise ArgumentError, "Invalid arguments when calling get_flow_type()"
    end
    #  Loads a JWK Set from the remote provider.
    # 
    #  When calling this method several times, the loaded JWKs are updated in the underlying JWT object.
    # @yield 
    # @return [self]
    def load_jwk
      if true
        @j_del.java_method(:loadJWK, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling load_jwk()"
    end
    # @param [::VertxAuthOauth2::OAuth2RBAC] rbac 
    # @return [self]
    def rbac_handler(rbac=nil)
      if rbac.class.method_defined?(:j_del) && !block_given?
        @j_del.java_method(:rbacHandler, [Java::IoVertxExtAuthOauth2::OAuth2RBAC.java_class]).call(rbac.j_del)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling rbac_handler(#{rbac})"
    end
  end
end
