require 'vertx-auth-oauth2/access_token'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.OAuth2RBAC
module VertxAuthOauth2
  #  Functional interface that allows users to implement custom RBAC verifiers for OAuth2/OpenId Connect.
  # 
  #  Users are to implement the <code>isAuthorized</code> method to verify authorities. For provides that do not
  #  export the permissions/roles in the token, this interface allows you to communicate with 3rd party services
  #  such as graph APIs to collect the required data.
  # 
  #  The contract is that once an authority is checked for a given user, it's value is cached during the execution
  #  of the request. If a user is stored to a persistent storage, or the token is introspected, the cache is cleared
  #  and a new call will be handled to the implementation.
  class OAuth2RBAC
    # @private
    # @param j_del [::VertxAuthOauth2::OAuth2RBAC] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::OAuth2RBAC] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == OAuth2RBAC
    end
    def @@j_api_type.wrap(obj)
      OAuth2RBAC.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2::OAuth2RBAC.java_class
    end
    #  This method should verify if the user has the given authority and return either a boolean value or an error.
    # 
    #  Note that false and errors are not the same. A user might not have a given authority but that doesn't mean that
    #  there was an error during the call.
    # @param [::VertxAuthOauth2::AccessToken] user the given user to assert on
    # @param [String] authority the authority to lookup
    # @yield the result handler.
    # @return [void]
    def is_authorized(user=nil,authority=nil)
      if user.class.method_defined?(:j_del) && authority.class == String && true
        return @j_del.java_method(:isAuthorized, [Java::IoVertxExtAuthOauth2::AccessToken.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(user.j_del,authority,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling is_authorized(#{user},#{authority})"
    end
  end
end
