require 'vertx/vertx'
require 'vertx-auth-oauth2/o_auth2_auth'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth
module VertxAuthOauth2
  #  Simplified factory to create an {::VertxAuthOauth2::OAuth2Auth} for OpenID Connect.
  class OpenIDConnectAuth
    # @private
    # @param j_del [::VertxAuthOauth2::OpenIDConnectAuth] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxAuthOauth2::OpenIDConnectAuth] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == OpenIDConnectAuth
    end
    def @@j_api_type.wrap(obj)
      OpenIDConnectAuth.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtAuthOauth2Providers::OpenIDConnectAuth.java_class
    end
    #  Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the given site in the
    #  configuration options and attempt to load the well known descriptor.
    # 
    #  If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
    #  into the OAuth provider so tokens can be decoded.
    # @param [::Vertx::Vertx] vertx the vertx instance
    # @param [Hash{String => Object}] config the initial config, it should contain a site url
    # @yield the instantiated Oauth2 provider instance handler
    # @return [void]
    def self.discover(vertx=nil,config=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && true
        return Java::IoVertxExtAuthOauth2Providers::OpenIDConnectAuth.java_method(:discover, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(vertx.j_del,Java::IoVertxExtAuthOauth2::OAuth2ClientOptions.new(::Vertx::Util::Utils.to_json_object(config)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxAuthOauth2::OAuth2Auth) : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling discover(#{vertx},#{config})"
    end
  end
end
