require 'vertx/pipe'
require 'vertx-redis/response'
require 'vertx/write_stream'
require 'vertx/vertx'
require 'vertx/read_stream'
require 'vertx/future'
require 'vertx-redis/request'
require 'vertx/util/utils.rb'
# Generated from io.vertx.redis.client.Redis
module VertxRedis
  #  A simple Redis client.
  class Redis
    include ::Vertx::ReadStream
    # @private
    # @param j_del [::VertxRedis::Redis] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxRedis::Redis] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == Redis
    end
    def @@j_api_type.wrap(obj)
      Redis.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxRedisClient::Redis.java_class
    end
    #  Pause this stream and return a  to transfer the elements of this stream to a destination .
    #  <p/>
    #  The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
    # @return [::Vertx::Pipe] a pipe
    def pipe
      if !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:pipe, []).call(),::Vertx::Pipe,::VertxRedis::Response.j_api_type)
      end
      raise ArgumentError, "Invalid arguments when calling pipe()"
    end
    #  Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
    #  <p>
    #  Elements emitted by this stream will be written to the write stream until this stream ends or fails.
    #  <p>
    #  Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
    #  called with the result.
    # @param [::Vertx::WriteStream] dst the destination write stream
    # @yield 
    # @return [void]
    def pipe_to(dst=nil)
      if dst.class.method_defined?(:j_del) && true
        return @j_del.java_method(:pipeTo, [Java::IoVertxCoreStreams::WriteStream.java_class,Java::IoVertxCore::Handler.java_class]).call(dst.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) } unless !block_given?))
      end
      raise ArgumentError, "Invalid arguments when calling pipe_to(#{dst})"
    end
    #  Connect to redis, the <code>onConnect</code> will get the {::VertxRedis::Redis} instance.
    # @overload createClient(vertx,address)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [String] address 
    # @overload createClient(vertx,options)
    #   @param [::Vertx::Vertx] vertx 
    #   @param [Hash{String => Object}] options 
    # @return [::VertxRedis::Redis]
    def self.create_client(param_1=nil,param_2=nil)
      if param_1.class.method_defined?(:j_del) && param_2.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Redis.java_method(:createClient, [Java::IoVertxCore::Vertx.java_class,Java::java.lang.String.java_class]).call(param_1.j_del,param_2),::VertxRedis::Redis)
      elsif param_1.class.method_defined?(:j_del) && param_2.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxRedisClient::Redis.java_method(:createClient, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxRedisClient::RedisOptions.java_class]).call(param_1.j_del,Java::IoVertxRedisClient::RedisOptions.new(::Vertx::Util::Utils.to_json_object(param_2))),::VertxRedis::Redis)
      end
      raise ArgumentError, "Invalid arguments when calling create_client(#{param_1},#{param_2})"
    end
    #  Connects to the redis server.
    # @yield the async result handler
    # @return [self]
    def connect
      if true
        @j_del.java_method(:connect, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Redis) : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling connect()"
    end
    #  Set an exception handler on the read stream.
    # @yield the exception handler
    # @return [self]
    def exception_handler
      if true
        @j_del.java_method(:exceptionHandler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.from_throwable(event)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling exception_handler()"
    end
    #  Set a data handler. As data is read, the handler will be called with the data.
    # @yield 
    # @return [self]
    def handler
      if true
        @j_del.java_method(:handler, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |event| yield(::Vertx::Util::Utils.safe_create(event,::VertxRedis::Response)) unless !block_given? }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling handler()"
    end
    #  Pause the <code>ReadStream</code>, it sets the buffer in <code>fetch</code> mode and clears the actual demand.
    #  <p>
    #  While it's paused, no data will be sent to the data <code>handler</code>.
    # @return [self]
    def pause
      if !block_given?
        @j_del.java_method(:pause, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling pause()"
    end
    #  Resume reading, and sets the buffer in <code>flowing</code> mode.
    #  <p/>
    #  If the <code>ReadStream</code> has been paused, reading will recommence on it.
    # @return [self]
    def resume
      if !block_given?
        @j_del.java_method(:resume, []).call()
        return self
      end
      raise ArgumentError, "Invalid arguments when calling resume()"
    end
    #  Fetch the specified <code>amount</code> of elements. If the <code>ReadStream</code> has been paused, reading will
    #  recommence with the specified <code>amount</code> of items, otherwise the specified <code>amount</code> will
    #  be added to the current stream demand.
    # @param [Fixnum] amount 
    # @return [self]
    def fetch(amount=nil)
      if amount.class == Fixnum && !block_given?
        @j_del.java_method(:fetch, [Java::long.java_class]).call(amount)
        return self
      end
      raise ArgumentError, "Invalid arguments when calling fetch(#{amount})"
    end
    #  Set an end handler. Once the stream has ended, and there is no more data to be read, this handler will be called.
    # @yield 
    # @return [self]
    def end_handler
      if true
        @j_del.java_method(:endHandler, [Java::IoVertxCore::Handler.java_class]).call(Proc.new { yield unless !block_given? })
        return self
      end
      raise ArgumentError, "Invalid arguments when calling end_handler()"
    end
    #  Send the given command to the redis server or cluster.
    # @param [::VertxRedis::Request] command the command to send
    # @yield the asynchronous result handler.
    # @return [self]
    def send(command=nil)
      if command.class.method_defined?(:j_del) && true
        @j_del.java_method(:send, [Java::IoVertxRedisClient::Request.java_class,Java::IoVertxCore::Handler.java_class]).call(command.j_del,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ::Vertx::Util::Utils.safe_create(ar.result,::VertxRedis::Response) : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling send(#{command})"
    end
    #  Sends a list of commands in a single IO operation, this prevents any inter twinning to happen from other
    #  client users.
    # @param [Array<::VertxRedis::Request>] commands list of command to send
    # @yield the asynchronous result handler.
    # @return [self]
    def batch(commands=nil)
      if commands.class == Array && true
        @j_del.java_method(:batch, [Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(commands.map { |element| element.j_del },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| ::Vertx::Util::Utils.safe_create(elt,::VertxRedis::Response) } : nil) } unless !block_given?))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling batch(#{commands})"
    end
    #  Returns the address associated with this client.
    # @return [String] the address.
    def socket_address
      if !block_given?
        return @j_del.java_method(:socketAddress, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling socket_address()"
    end
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
